/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tomatoart.poster.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.bingoogolapple.qrcode.zxing.QRCodeEncoder;
import com.gymchina.library.autosize.DimensPTKt;
import com.gymchina.library.common.extend.ViewKt;
import com.gymchina.tomatoart.PosterConfig;
import com.gymchina.tomatoart.poster.PosterUtils;
import com.gymchina.tomatoart.poster.entity.Attrs;
import com.gymchina.tomatoart.poster.entity.LocalPicAttrs;
import com.gymchina.tomatoart.poster.entity.PicAttrs;
import com.gymchina.tomatoart.poster.entity.Poster;
import com.gymchina.tomatoart.poster.entity.PosterBuildData;
import com.gymchina.tomatoart.poster.entity.PosterPhoto;
import com.gymchina.tomatoart.poster.entity.PosterTemplate;
import com.gymchina.tomatoart.poster.entity.Student;
import com.gymchina.tomatoart.poster.entity.TextAttrs;
import com.gymchina.tomatoart.poster.views.PosterTemplateLayout;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.anko.CustomLayoutPropertiesKt;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.anko.Sdk25PropertiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020!H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/gymchina/tomatoart/poster/views/PosterTemplateLayout;", "Landroid/widget/RelativeLayout;", "ctx", "Landroid/content/Context;", "poster", "Lcom/gymchina/tomatoart/poster/entity/Poster;", "(Landroid/content/Context;Lcom/gymchina/tomatoart/poster/entity/Poster;)V", "getCtx", "()Landroid/content/Context;", "getPoster", "()Lcom/gymchina/tomatoart/poster/entity/Poster;", "sizeScale", "", "createBookNameSymbol", "Landroid/widget/TextView;", "attrs", "Lcom/gymchina/tomatoart/poster/entity/TextAttrs;", "rotation", "", "isLeft", "", "createForegroundColor", "Landroid/text/SpannableStringBuilder;", "content", "", "fgContent", "createLayoutParams", "Landroid/widget/RelativeLayout$LayoutParams;", "Lcom/gymchina/tomatoart/poster/entity/Attrs;", "createTextViewByAttrs", "createTitleView", "htmlTitle", "fillBackground", "", "fillComment", "fillPicture", "fillQrCode", "fillSchool", "fillStudent", "fillTitle", "fillViews", "getPxValueAttrs", "getQrCodeContent", "toPx", "", "size", "poster_release"})
@SuppressLint(value={"ViewConstructor"})
public final class PosterTemplateLayout
extends RelativeLayout {
    private final double sizeScale;
    @NotNull
    private final Context ctx;
    @NotNull
    private final Poster poster;

    private final int toPx(int size) {
        return (int)((double)size * this.sizeScale);
    }

    private final void fillViews() {
        this.fillPicture();
        this.fillBackground();
        this.fillQrCode();
        this.fillTitle();
        this.fillStudent();
        this.fillSchool();
        this.fillComment();
    }

    private final void fillPicture() {
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getPicture()) == null) {
            return;
        }
        Object attrs = object;
        PosterPhoto posterPhoto = this.poster.getPhoto();
        if (posterPhoto == null || (posterPhoto = posterPhoto.getCropBitmap()) == null) {
            return;
        }
        PosterPhoto bitmap = posterPhoto;
        ImageView imageView = new ImageView(this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$apply = imageView;
        boolean bl3 = false;
        $this$apply.setScaleType(ImageView.ScaleType.FIT_XY);
        Sdk25PropertiesKt.setImageBitmap((ImageView)$this$apply, (Bitmap)bitmap);
        ImageView view = imageView;
        this.addView((View)view, (ViewGroup.LayoutParams)this.createLayoutParams((Attrs)attrs));
    }

    private final void fillBackground() {
        Attrs attrs;
        PosterTemplate posterTemplate = this.poster.getTemplate();
        if ((posterTemplate != null ? posterTemplate.getLocalBackground() : null) != null) {
            PosterTemplate posterTemplate2 = this.poster.getTemplate();
            LocalPicAttrs localPicAttrs = posterTemplate2 != null ? posterTemplate2.getLocalBackground() : null;
            if (localPicAttrs == null) {
                Intrinsics.throwNpe();
            }
            attrs = localPicAttrs;
        } else {
            PosterTemplate posterTemplate3 = this.poster.getTemplate();
            if ((posterTemplate3 != null ? posterTemplate3.getBackground() : null) != null) {
                PosterTemplate posterTemplate4 = this.poster.getTemplate();
                PicAttrs picAttrs = posterTemplate4 != null ? posterTemplate4.getBackground() : null;
                if (picAttrs == null) {
                    Intrinsics.throwNpe();
                }
                attrs = picAttrs;
            } else {
                return;
            }
        }
        Attrs attrs2 = attrs;
        Bitmap bitmap = this.poster.getBackgroundBitmap();
        if (bitmap == null) {
            return;
        }
        Bitmap bitmap2 = bitmap;
        ImageView imageView = new ImageView(this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$apply = imageView;
        boolean bl3 = false;
        $this$apply.setScaleType(ImageView.ScaleType.FIT_XY);
        Sdk25PropertiesKt.setImageBitmap((ImageView)$this$apply, (Bitmap)bitmap2);
        ImageView view = imageView;
        this.addView((View)view, (ViewGroup.LayoutParams)this.createLayoutParams(attrs2));
    }

    private final void fillQrCode() {
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getQrcode()) == null) {
            return;
        }
        Object attrs = object;
        String string2 = this.getQrCodeContent();
        if (string2 == null) {
            return;
        }
        String content = string2;
        AsyncKt.doAsync$default((Object)this.ctx, null, (Function1)((Function1)new Function1<AnkoAsyncContext<Context>, Unit>(this, content, (Attrs)attrs){
            final /* synthetic */ PosterTemplateLayout this$0;
            final /* synthetic */ String $content;
            final /* synthetic */ Attrs $attrs;

            public final void invoke(@NotNull AnkoAsyncContext<Context> $this$doAsync) {
                Intrinsics.checkParameterIsNotNull($this$doAsync, (String)"$receiver");
                Bitmap bitmap = QRCodeEncoder.syncEncodeQRCode((String)this.$content, (int)PosterTemplateLayout.access$toPx(this.this$0, this.$attrs.getW()));
                if (bitmap == null) {
                    return;
                }
                Bitmap bitmap2 = bitmap;
                AsyncKt.runOnUiThread((Context)this.this$0.getCtx(), (Function1)((Function1)new Function1<Context, Unit>(this, bitmap2){
                    final /* synthetic */ fillQrCode.1 this$0;
                    final /* synthetic */ Bitmap $bitmap;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Context $this$runOnUiThread) {
                        ImageView imageView;
                        void var10_3;
                        Intrinsics.checkParameterIsNotNull((Object)$this$runOnUiThread, (String)"$receiver");
                        Context $receiver$iv = $this$runOnUiThread;
                        void var11_4 = var10_3 = imageView;
                        imageView = new ImageView((Context)var11_4);
                        boolean bl = false;
                        boolean bl2 = false;
                        ImageView $this$apply = imageView;
                        boolean bl3 = false;
                        $this$apply.setScaleType(ImageView.ScaleType.FIT_XY);
                        Sdk25PropertiesKt.setImageBitmap((ImageView)$this$apply, (Bitmap)this.$bitmap);
                        ImageView view = imageView;
                        this.this$0.this$0.addView((View)view, (ViewGroup.LayoutParams)PosterTemplateLayout.access$createLayoutParams(this.this$0.this$0, this.this$0.$attrs));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$bitmap = bitmap;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = posterTemplateLayout;
                this.$content = string2;
                this.$attrs = attrs;
                super(1);
            }
        }), (int)1, null);
    }

    private final String getQrCodeContent() {
        return PosterConfig.Companion.getPOSTER_QRCODE_CONTENT();
    }

    private final void fillTitle() {
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getTitle()) == null) {
            return;
        }
        Object attrs = object;
        Object object2 = this.poster.getBuildData();
        if (object2 == null || (object2 = ((PosterBuildData)object2).getTitle()) == null) {
            object2 = "";
        }
        Object title = object2;
        String htmlTitle = PosterUtils.Companion.getHtmlWithOmitByContent((String)title, 6);
        Integer n = ((TextAttrs)attrs).getEmsForLine();
        boolean isVertical = n != null && n == 1;
        LinearLayout linearLayout = new LinearLayout(this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        LinearLayout $this$apply = linearLayout;
        boolean bl3 = false;
        $this$apply.setOrientation(isVertical ? 1 : 0);
        $this$apply.setGravity(17);
        float rotation = isVertical ? 90.0f : 0.0f;
        $this$apply.addView((View)this.createBookNameSymbol((TextAttrs)attrs, rotation, true));
        TextView titleView = this.createTitleView((TextAttrs)attrs, htmlTitle);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(CustomLayoutPropertiesKt.getWrapContent(), CustomLayoutPropertiesKt.getWrapContent());
        boolean bl4 = false;
        boolean bl5 = false;
        LinearLayout.LayoutParams $this$apply2 = layoutParams;
        boolean bl6 = false;
        if (isVertical) {
            int margin = (int)(titleView.getTextSize() * 0.8f);
            CustomLayoutPropertiesKt.setVerticalMargin((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)$this$apply2), (int)(-margin));
        }
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        $this$apply.addView((View)titleView, (ViewGroup.LayoutParams)layoutParams2);
        $this$apply.addView((View)this.createBookNameSymbol((TextAttrs)attrs, rotation, false));
        LinearLayout layout = linearLayout;
        this.addView((View)layout, (ViewGroup.LayoutParams)this.createLayoutParams((Attrs)attrs));
    }

    private final TextView createTitleView(TextAttrs attrs, String htmlTitle) {
        TextView textView = this.createTextViewByAttrs(attrs);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        $this$apply.setText(PosterUtils.Companion.forHtmlRemoveWhiteSpace(htmlTitle));
        $this$apply.setGravity(17);
        return textView;
    }

    private final TextView createBookNameSymbol(TextAttrs attrs, float rotation, boolean isLeft) {
        int n;
        TextView textView = new TextView(this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        if (attrs.getSize() != null) {
            Integer n2 = attrs.getSize();
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            n = this.toPx(n2);
        } else {
            n = DimensPTKt.getPt16();
        }
        int sizePx = n;
        sizePx = (int)((double)sizePx * 1.5);
        CustomViewPropertiesKt.setBottomPadding((View)((View)$this$apply), (int)((int)((double)sizePx * 0.18)));
        TextView $receiver$iv = $this$apply;
        $receiver$iv.setTextSize(0, (float)sizePx);
        $this$apply.setMaxLines(1);
        $this$apply.setGravity(17);
        $this$apply.setRotation(rotation);
        $this$apply.setIncludeFontPadding(false);
        String string2 = attrs.getColor();
        if (string2 == null) {
            string2 = "#000000";
        }
        Sdk25PropertiesKt.setTextColor((TextView)$this$apply, (int)Color.parseColor((String)string2));
        String content = isLeft ? "<p>&#171;&#160;</p>" : "<p>&#160;&#187;</p>";
        $this$apply.setText(PosterUtils.Companion.forHtmlRemoveWhiteSpace(content));
        return textView;
    }

    private final void fillStudent() {
        String string2;
        String studentName;
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getStudent()) == null) {
            return;
        }
        Object attrs = object;
        Object object2 = this.poster.getBuildData();
        if (object2 == null || (object2 = ((PosterBuildData)object2).getStudent()) == null) {
            return;
        }
        Object student = object2;
        String string3 = ((Student)student).getName();
        if (string3 == null) {
            string3 = studentName = "";
        }
        if ((string2 = ((Student)student).getAge()) == null) {
            string2 = "";
        }
        String studentAge = string2;
        String content = studentName + "   " + studentAge;
        TextView textView = this.createTextViewByAttrs((TextAttrs)attrs);
        textView.setText((CharSequence)this.createForegroundColor(content, studentAge, (TextAttrs)attrs));
        this.addView((View)textView, (ViewGroup.LayoutParams)this.createLayoutParams((Attrs)attrs));
    }

    private final void fillSchool() {
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getSchool()) == null) {
            return;
        }
        Object attrs = object;
        Object object2 = this.poster.getBuildData();
        if (object2 == null || (object2 = ((PosterBuildData)object2).getStudent()) == null) {
            return;
        }
        Object student = object2;
        TextView textView = this.createTextViewByAttrs((TextAttrs)attrs);
        String string2 = ((Student)student).getSchoolName();
        textView.setText(string2 != null ? (CharSequence)string2 : (CharSequence)"");
        textView.setEllipsize(TextUtils.TruncateAt.END);
        this.addView((View)textView, (ViewGroup.LayoutParams)this.createLayoutParams((Attrs)attrs));
    }

    private final void fillComment() {
        Object object = this.poster.getTemplate();
        if (object == null || (object = ((PosterTemplate)object).getComment()) == null) {
            return;
        }
        Object attrs = object;
        Object object2 = this.poster.getBuildData();
        if (object2 == null || (object2 = ((PosterBuildData)object2).getAppraise()) == null) {
            object2 = "";
        }
        Object comment = object2;
        String fgContent = "\u8001\u5e08\u8bc4\u8bed\uff1a";
        String content = fgContent + (String)comment;
        TextView textView = this.createTextViewByAttrs((TextAttrs)attrs);
        textView.setText((CharSequence)this.createForegroundColor(content, fgContent, (TextAttrs)attrs));
        textView.setEllipsize(TextUtils.TruncateAt.END);
        this.addView((View)textView, (ViewGroup.LayoutParams)this.createLayoutParams((Attrs)attrs));
    }

    /*
     * WARNING - void declaration
     */
    private final TextView createTextViewByAttrs(TextAttrs attrs) {
        String string2;
        int n;
        TextView textView = new TextView(this.ctx);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        if (attrs.getSize() != null) {
            Integer n2 = attrs.getSize();
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            n = this.toPx(n2);
        } else {
            n = DimensPTKt.getPt16();
        }
        int sizePx = n;
        TextView $receiver$iv = $this$apply;
        $receiver$iv.setTextSize(0, (float)sizePx);
        if (attrs.getLines() != null) {
            Integer n3 = attrs.getLines();
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.setMaxLines(n3.intValue());
        }
        if (attrs.getEmsForLine() != null) {
            void value$iv;
            Integer n4 = attrs.getEmsForLine();
            if (n4 == null) {
                Intrinsics.throwNpe();
            }
            int $i$f$textSizePx = n4;
            $receiver$iv = $this$apply;
            $receiver$iv.setEms((int)value$iv);
        }
        if ((string2 = attrs.getColor()) == null) {
            string2 = "#000000";
        }
        Sdk25PropertiesKt.setTextColor((TextView)$this$apply, (int)Color.parseColor((String)string2));
        return textView;
    }

    private final SpannableStringBuilder createForegroundColor(String content, String fgContent, TextAttrs attrs) {
        CharSequence charSequence = attrs.getStressColor();
        boolean bl = false;
        boolean bl2 = false;
        int fgColor = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? Color.parseColor((String)attrs.getStressColor()) : -65536;
        charSequence = new SpannableStringBuilder((CharSequence)content);
        bl = false;
        bl2 = false;
        CharSequence $this$apply = charSequence;
        boolean bl3 = false;
        int startIndex = StringsKt.indexOf$default((CharSequence)content, (String)fgContent, (int)0, (boolean)false, (int)6, null);
        if (startIndex >= 0) {
            $this$apply.setSpan(new ForegroundColorSpan(fgColor), startIndex, startIndex + fgContent.length(), 34);
        }
        return charSequence;
    }

    private final RelativeLayout.LayoutParams createLayoutParams(Attrs attrs) {
        Attrs tmpAttrs = this.getPxValueAttrs(attrs);
        int width = tmpAttrs.getW() > 0 ? tmpAttrs.getW() : CustomLayoutPropertiesKt.getWrapContent();
        int height = tmpAttrs.getH() > 0 ? tmpAttrs.getH() : CustomLayoutPropertiesKt.getWrapContent();
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
        boolean bl = false;
        boolean bl2 = false;
        RelativeLayout.LayoutParams $this$apply = layoutParams;
        boolean bl3 = false;
        $this$apply.leftMargin = tmpAttrs.getX();
        $this$apply.topMargin = tmpAttrs.getY();
        return layoutParams;
    }

    private final Attrs getPxValueAttrs(Attrs attrs) {
        return new Attrs(this.toPx(attrs.getX()), this.toPx(attrs.getY()), this.toPx(attrs.getW()), this.toPx(attrs.getH()));
    }

    @NotNull
    public final Context getCtx() {
        return this.ctx;
    }

    @NotNull
    public final Poster getPoster() {
        return this.poster;
    }

    public PosterTemplateLayout(@NotNull Context ctx, @NotNull Poster poster) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)poster, (String)"poster");
        super(ctx);
        this.ctx = ctx;
        this.poster = poster;
        int layoutWidth = DimensPTKt.getPt588();
        Object object = this.poster.getTemplate();
        int width = object != null && (object = ((PosterTemplate)object).getWidth()) != null ? (Integer)object : 0;
        this.sizeScale = (double)layoutWidth / (double)width;
        Object object2 = this.poster.getTemplate();
        int height = object2 != null && (object2 = ((PosterTemplate)object2).getHeight()) != null ? (Integer)object2 : 0;
        int layoutHeight = this.toPx(height);
        ViewKt.setViewSize((View)((View)this), (int)layoutWidth, (int)layoutHeight);
        this.fillViews();
    }

    public static final /* synthetic */ int access$toPx(PosterTemplateLayout $this, int size) {
        return $this.toPx(size);
    }

    public static final /* synthetic */ RelativeLayout.LayoutParams access$createLayoutParams(PosterTemplateLayout $this, Attrs attrs) {
        return $this.createLayoutParams(attrs);
    }
}

