/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.pay.client.request.multi;

import com.gymchina.pay.client.request.RefundRequest;
import com.gymchina.pay.client.request.interfaces.IMultiRequest;
import com.gymchina.pay.client.request.interfaces.IRequest;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.tuple.Pair;

public class MultiRefundRequest
implements IMultiRequest {
    private List<String> tradeIds;
    private String refundDesc;
    private String nodifyUrl;

    private MultiRefundRequest() {
    }

    public static MultiRefundRequest of() {
        return new MultiRefundRequest();
    }

    public List<String> getTradeIds() {
        return this.tradeIds;
    }

    public MultiRefundRequest setTradeIds(List<String> tradeIds) {
        this.tradeIds = tradeIds;
        return this;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public MultiRefundRequest setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
        return this;
    }

    public String getNodifyUrl() {
        return this.nodifyUrl;
    }

    public MultiRefundRequest setNodifyUrl(String nodifyUrl) {
        this.nodifyUrl = nodifyUrl;
        return this;
    }

    @Override
    public ConcurrentLinkedQueue<Pair<String, ? extends IRequest>> changeToRequest() {
        if (ArrayMapTools.isEmpty(this.tradeIds) || StringTools.isAnyEmpty((CharSequence[])new CharSequence[]{this.refundDesc, this.nodifyUrl})) {
            return null;
        }
        ConcurrentLinkedQueue<Pair<String, ? extends IRequest>> queue = new ConcurrentLinkedQueue<Pair<String, ? extends IRequest>>();
        for (String tradeId : this.tradeIds) {
            queue.add((Pair<String, ? extends IRequest>)Pair.of((Object)tradeId, (Object)RefundRequest.of().setTradeId(tradeId).setRefundDesc(this.refundDesc).setNodifyUrl(this.nodifyUrl)));
        }
        return queue;
    }
}

