package com.gymchina.pay.client.request;

import com.gymchina.bean.enums.PaymentEnum;
import com.gymchina.pay.client.request.IRequest;

public class PrecreateRequest implements IRequest {
	private PrecreateRequest() {
	}

	@Override
	public String mapping() {
		return "trade/precreate";
	}

	private String orderId;
	private String productName;
	private Integer price;
	private PaymentEnum type;
	private String clientV4IP;
	private String nodifyUrl;
	private String attachData;
	private String showUrl;
	private String returnUrl;
	private String wechatCode;

	public static PrecreateRequest of(String orderId) {
		return new PrecreateRequest().setOrderId(orderId);
	}

	public String getOrderId() {
		return orderId;
	}

	public PrecreateRequest setOrderId(String orderId) {
		this.orderId = orderId;
		return this;
	}

	public String getProductName() {
		return productName;
	}

	public PrecreateRequest setProductName(String productName) {
		this.productName = productName;
		return this;
	}

	public Integer getPrice() {
		return price;
	}

	public PrecreateRequest setPrice(Integer price) {
		this.price = price;
		return this;
	}

	public PaymentEnum getType() {
		return type;
	}

	public PrecreateRequest setType(PaymentEnum type) {
		if (null == type || type.isRoot())
			throw new IllegalArgumentException("can't used root node for payment type");
		this.type = type;
		return this;
	}

	public String getClientV4IP() {
		return clientV4IP;
	}

	public PrecreateRequest setClientV4IP(String clientV4IP) {
		this.clientV4IP = clientV4IP;
		return this;
	}

	public String getNodifyUrl() {
		return nodifyUrl;
	}

	public PrecreateRequest setNodifyUrl(String nodifyUrl) {
		this.nodifyUrl = nodifyUrl;
		return this;
	}

	public String getAttachData() {
		return attachData;
	}

	public PrecreateRequest setAttachData(String attachData) {
		this.attachData = attachData;
		return this;
	}

	public String getShowUrl() {
		return showUrl;
	}

	public PrecreateRequest setShowUrl(String showUrl) {
		this.showUrl = showUrl;
		return this;
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public PrecreateRequest setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
		return this;
	}

	public String getWechatCode() {
		return wechatCode;
	}

	public PrecreateRequest setWechatCode(String wechatCode) {
		this.wechatCode = wechatCode;
		return this;
	}

}
