package com.gymchina.pay.client;

import java.lang.reflect.Field;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;

import com.google.common.collect.Maps;
import com.gymchina.bean.response.GymchinaPayCommonResponse;
import com.gymchina.bean.tools.PaymentHttpTool;
import com.gymchina.pay.client.request.IRequest;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;

/**
 * @Title PayClient
 * @Package com.gymchina.pay.client
 * @author tangjunfeng
 * @date 2019年9月17日 上午10:36:22
 * @version V1.0
 */
public class PayClient {

	private String payUrl, signKey, utf8 = "utf-8";
	private boolean showLog;

	private PayClient(String payUrl, String signKey, boolean showLog) {
		this.payUrl = payUrl;
		this.signKey = signKey;
		this.showLog = showLog;
	}

	public static PayClient getClient(String payUrl, String signKey) {
		return getClient(payUrl, signKey, false);
	}

	public static PayClient getClient(String payUrl, String signKey, boolean showLog) {
		if (!StringTools.startsWithAny(payUrl, "http://", "https://"))
			throw new IllegalArgumentException("invalid pay url");
		return new PayClient(payUrl, signKey, showLog);
	}

	public GymchinaPayCommonResponse invokeGymchinaPay(IRequest request) throws Exception {
		Map<String, String> param = getParam(request);
		param.put("sign", PaymentHttpTool.getGymchinaPayParamSign(param, signKey));
		String url = getRequestUrl(request.mapping());
		String result = ConnectPost.send(url, param, utf8, showLog);
		if (null == result)
			return null;
		return GsonTools.gson.fromJson(result, GymchinaPayCommonResponse.class);
	}

	private Map<String, String> getParam(IRequest request) throws Exception {
		Map<String, String> has = Maps.newHashMap();
		try {
			String value = null;
			for (Field field : request.getClass().getDeclaredFields()) {
				value = BeanUtils.getSimpleProperty(request, field.getName());
				if (null != value)
					has.put(field.getName(), value);
			}
			return has;
		} catch (IllegalArgumentException | IllegalAccessException e) {
			throw e;
		}
	}

	private String getRequestUrl(String mapping) {
		if (mapping.startsWith("/"))
			mapping = mapping.substring(1);
		if (payUrl.endsWith("/"))
			return payUrl + mapping;
		return payUrl + "/" + mapping;
	}
}
