/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.swagger;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.web.bind.annotation.RequestMapping;

public class DiscoverySwagger {
    private static final StringBuffer sb = new StringBuffer();

    public static List<String> discoveryMappingUrl(String ... packages) throws IOException, ClassNotFoundException, URISyntaxException {
        List<BeanDefinition> beans = DiscoverySwagger.getClassUrl(packages);
        if (null == beans || beans.isEmpty()) {
            return null;
        }
        ArrayList resultUrls = Lists.newArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (BeanDefinition beanDefinition : beans) {
            Class<?> clazz = classLoader.loadClass(beanDefinition.getBeanClassName());
            if (!DiscoverySwagger.isWithAnnotation(clazz, Api.class) || !DiscoverySwagger.isWithAnnotation(clazz, RequestMapping.class)) continue;
            resultUrls.addAll(DiscoverySwagger.getSwaggerUrls(clazz.getAnnotation(RequestMapping.class).value()));
        }
        return resultUrls;
    }

    private static List<BeanDefinition> getClassUrl(String ... packages) {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Api.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RequestMapping.class));
        ArrayList<BeanDefinition> beanClass = new ArrayList<BeanDefinition>();
        Set tempBeans = null;
        for (String pk : packages) {
            tempBeans = componentProvider.findCandidateComponents(pk);
            if (null == tempBeans || tempBeans.isEmpty()) continue;
            beanClass.addAll(tempBeans);
        }
        return beanClass;
    }

    private static boolean isWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    private static List<String> getSwaggerUrls(String ... values) {
        ArrayList result = Lists.newArrayList();
        for (String val : values) {
            sb.delete(0, sb.length()).append(val);
            if (sb.indexOf("/") != 0) {
                sb.insert(0, "/");
            }
            if (sb.lastIndexOf("/") != sb.length() - 1) {
                sb.append("/");
            }
            sb.append(".*");
            result.add(sb.toString());
        }
        return result;
    }
}

