package com.gymchina.tiny.swagger;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.web.bind.annotation.RequestMapping;

import com.google.common.collect.Lists;

import io.swagger.annotations.Api;

public class DiscoverySwagger {

	public static List<String> discoveryMappingUrl(String... packages)
			throws IOException, ClassNotFoundException, URISyntaxException {
		List<BeanDefinition> beans = getClassUrl(packages);
		if (null == beans || beans.isEmpty())
			return null;
		List<String> resultUrls = Lists.newArrayList();
		ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
		for (BeanDefinition beanDefinition : beans) {
			Class<?> clazz = classLoader.loadClass(beanDefinition.getBeanClassName());
			if (isWithAnnotation(clazz, Api.class) && isWithAnnotation(clazz, RequestMapping.class))
				resultUrls.addAll(getSwaggerUrls(clazz.getAnnotation(RequestMapping.class).value()));
		}
		return resultUrls;
	}

	private static List<BeanDefinition> getClassUrl(String... packages) {
		ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(
				false);
		componentProvider.addIncludeFilter(new AnnotationTypeFilter(Api.class));
		componentProvider.addIncludeFilter(new AnnotationTypeFilter(RequestMapping.class));
		List<BeanDefinition> beanClass = new ArrayList<>();
		Set<BeanDefinition> tempBeans = null;
		for (String pk : packages) {
			tempBeans = componentProvider.findCandidateComponents(pk);
			if (null != tempBeans && !tempBeans.isEmpty())
				beanClass.addAll(tempBeans);
		}
		return beanClass;
	}

	private static boolean isWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
		return clazz.isAnnotationPresent(annotationClass);
	}

	private static final StringBuffer sb = new StringBuffer();

	private static List<String> getSwaggerUrls(String... values) {
		List<String> result = Lists.newArrayList();
		for (String val : values) {
			sb.delete(0, sb.length()).append(val);
			if (sb.indexOf("/") != 0)
				sb.insert(0, "/");
			if (sb.lastIndexOf("/") != sb.length() - 1)
				sb.append("/");
			sb.append(".*");
			result.add(sb.toString());
		}
		return result;
	}

}
