/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.swagger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.gymchina.tiny.swagger.DiscoverySwagger;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public abstract class SwaggerRegisterConfiguration {
    private static Logger logger = LoggerFactory.getLogger(SwaggerRegisterConfiguration.class);

    @Bean
    public Docket petApi() throws ClassNotFoundException, IOException, URISyntaxException {
        logger.info("Loadding Swagger Interfaces Infomation [Title : {} , creater : {}]", (Object)this.title(), (Object)this.creater());
        return new Docket(DocumentationType.SWAGGER_2).groupName("full-api").apiInfo(this.apiInfo()).select().paths(this.petstorePaths()).build().useDefaultResponseMessages(false);
    }

    public abstract String[] swaggerPackages();

    public Predicate<String> petstorePaths() throws ClassNotFoundException, IOException, URISyntaxException {
        List<String> urls = DiscoverySwagger.discoveryMappingUrl(this.swaggerPackages());
        if (null == urls || urls.isEmpty()) {
            return Predicates.or((Predicate[])new Predicate[0]);
        }
        Predicate[] predicates = new Predicate[urls.size()];
        for (int i = 0; i < urls.size(); ++i) {
            predicates[i] = PathSelectors.regex((String)urls.get(i));
        }
        return Predicates.or((Predicate[])predicates);
    }

    public String title() {
        return "\u63a5\u53e3\u8bf4\u660e\u6587\u6863";
    }

    public String description() {
        return "\u8be6\u7ec6\u8bf4\u660e(\u53ef\u8986\u76d6\u7236\u7c7b\u65b9\u6cd5)";
    }

    public String creater() {
        return "creater";
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title()).description(this.description()).termsOfServiceUrl("http://jz.gymchina.com").contact(new Contact(this.creater(), "", "")).build();
    }
}

