package com.gymchina.tiny.mvc.errors;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

/**
 * @Title HttpServletErrorAttributes
 * @Package com.gymchina.tiny.mvc.errors
 * @author tangjunfeng
 * @date 2018年12月25日 上午11:07:09
 * @version V1.0
 */
@Component
public class HttpServletErrorAttributes {

	public String getErrorMessage(HttpServletRequest request) {
		WebRequest webRequest = new ServletWebRequest(request);
		Throwable error = getError(webRequest);
		if (error != null) {
			while (error instanceof ServletException && error.getCause() != null) {
				error = ((ServletException) error).getCause();
			}
			return addErrorMessage(error);
		}
		String message = getAttribute(webRequest, "javax.servlet.error.message");
		if (!StringUtils.isEmpty(message)) {
			return StringUtils.isEmpty(message) ? "No message available" : message;
		}
		return null;
	}

	private String addErrorMessage(Throwable error) {
		BindingResult result = extractBindingResult(error);
		if (result == null) {
			return error.getMessage();
		}
		if (result.getErrorCount() > 0) {
			System.out.println("errors : " + result.getAllErrors());
			return "Validation failed for object='" + result.getObjectName() + "'. Error count: "
					+ result.getErrorCount();
		}
		return null;
	}

	private BindingResult extractBindingResult(Throwable error) {
		if (error instanceof BindingResult) {
			return (BindingResult) error;
		}
		if (error instanceof MethodArgumentNotValidException) {
			return ((MethodArgumentNotValidException) error).getBindingResult();
		}
		return null;
	}

	public Throwable getError(WebRequest webRequest) {
		Throwable exception = getAttribute(webRequest, "org.springframework.boot.web.servlet.error.DefaultErrorAttributes.ERROR");
		if (null != exception)
			return exception;
		return getAttribute(webRequest, "javax.servlet.error.exception");
	}

	@SuppressWarnings("unchecked")
	private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
		return (T) requestAttributes.getAttribute(name, RequestAttributes.SCOPE_REQUEST);
	}
}
