package com.gymchina.tiny.mvc.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.gymchina.tiny.mvc.filters.TinyMvcHttpRequestLogger;

@Configuration
public class TinyMvcFilterRegistryAdapter {

	private static Logger logger = LoggerFactory.getLogger(TinyMvcFilterRegistryAdapter.class);

	@Value("${mvc.show.request.url:true}")
	private boolean showRequestUrl;

	@Bean
	public FilterRegistrationBean<TinyMvcHttpRequestLogger> tinyMvcHttpRequestLogger() {
		logger.info("Invocation TinyMvcHttpRequestLogger Finish");
		logger.info("Spring Boot Show Request Url Service : {}", showRequestUrl ? "ON" : "OFF");
		FilterRegistrationBean<TinyMvcHttpRequestLogger> registrationBean = new FilterRegistrationBean<>();
		registrationBean.setFilter(new TinyMvcHttpRequestLogger(showRequestUrl));
		registrationBean.setOrder(-1);
		registrationBean.setName("tinyMvcHttpRequestLogger");
		registrationBean.addUrlPatterns("/*");
		return registrationBean;
	}

}
