/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.filters;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinyMvcHttpRequestLogFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(TinyMvcHttpRequestLogFilter.class);
    private static boolean showRequestUrl = true;

    public TinyMvcHttpRequestLogFilter() {
    }

    public TinyMvcHttpRequestLogFilter(boolean showRequestUrl) {
        TinyMvcHttpRequestLogFilter.showRequestUrl = showRequestUrl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        long startTimestamp = System.currentTimeMillis();
        StringBuffer sb = null;
        if (showRequestUrl) {
            sb = new StringBuffer(httpRequest.getMethod()).append(" ");
            sb.append(httpRequest.getRequestURI()).append("?");
            Enumeration names = request.getParameterNames();
            String element = null;
            while (names.hasMoreElements()) {
                element = (String)names.nextElement();
                sb.append(element).append("=").append(request.getParameter(element)).append("&");
            }
            sb.delete(sb.length() - 1, sb.length()).append(" - ");
        }
        int status = 0;
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            status = httpResponse.getStatus();
        }
        catch (Throwable e) {
            status = 500;
            throw e;
        }
        finally {
            this.loggerRequestInfo(sb, startTimestamp, status, httpResponse);
        }
    }

    public void destroy() {
    }

    private void loggerRequestInfo(StringBuffer sb, long startTimestamp, int status, HttpServletResponse httpResponse) {
        if (!showRequestUrl) {
            return;
        }
        sb.append(httpResponse.getContentType()).append(" ");
        sb.append(status).append(" - ");
        long timestamp = System.currentTimeMillis() - startTimestamp;
        sb.append("Timer : ").append(timestamp).append("ms");
        logger.info(sb.toString());
        if (timestamp > 3000L) {
            logger.warn(sb.toString());
        }
    }
}

