/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.core;

import com.gymchina.tiny.common.global.TinyCommon;
import com.gymchina.tiny.mvc.other.TinyBanner;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

public class TinyMvcApplication {
    private static final String localPackageName = "com.gymchina.tiny";

    public static void run(Class<?> primary, String[] args) {
        if (!primary.isAnnotationPresent(SpringBootApplication.class)) {
            return;
        }
        try {
            TinyMvcApplication.refreshComponentScan(primary);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            SpringApplication application = new SpringApplication(new Class[]{primary});
            application.setBanner((Banner)new TinyBanner());
            application.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPrimaryPackageNameSecond(Class<?> primary) {
        String[] ps = primary.getPackage().getName().split("\\.");
        if (ps.length <= 2) {
            return primary.getPackage().getName();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ps.length && i <= 1; ++i) {
            sb.append(ps[i]).append(".");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    private static void refreshComponentScan(Class<?> primary) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String primaryPackageName = TinyMvcApplication.getPrimaryPackageNameSecond(primary);
        ComponentScan proxyAnnotation = null;
        String fieldName = null;
        if (primary.isAnnotationPresent(ComponentScan.class)) {
            proxyAnnotation = primary.getAnnotation(ComponentScan.class);
            fieldName = "value";
        } else {
            proxyAnnotation = primary.getAnnotation(SpringBootApplication.class);
            fieldName = "scanBasePackages";
        }
        InvocationHandler handler = Proxy.getInvocationHandler(proxyAnnotation);
        Field memberValuesField = handler.getClass().getDeclaredField("memberValues");
        memberValuesField.setAccessible(true);
        Map memberValues = (Map)memberValuesField.get(handler);
        ArrayList<String> packs = new ArrayList<String>(Arrays.asList((String[])memberValues.get(fieldName)));
        packs.add(localPackageName);
        if (!packs.contains(primaryPackageName)) {
            packs.add(primaryPackageName);
        }
        String[] array = new String[]{};
        memberValues.put(fieldName, packs.toArray(array));
        TinyCommon.scanPacks.addAll(packs);
    }
}

