/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.module.mall.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.List;
import net.lucode.hackware.magicindicator.NavigatorHelper;
import net.lucode.hackware.magicindicator.abs.IPagerNavigator;
import net.lucode.hackware.magicindicator.buildins.ArgbEvaluatorHolder;
import net.lucode.hackware.magicindicator.buildins.UIUtil;

public class ScaleCircleNavigator
extends View
implements IPagerNavigator,
NavigatorHelper.OnNavigatorScrollListener {
    private int mMinRadius;
    private int mMaxRadius;
    private int mNormalCircleColor = -3355444;
    private int mSelectedCircleColor = -7829368;
    private int mCircleSpacing;
    private int mCircleCount;
    private Paint mPaint = new Paint(1);
    private List<PointF> mCirclePoints = new ArrayList<PointF>();
    private SparseArray<Float> mCircleRadiusArray = new SparseArray();
    private boolean mTouchable;
    private OnCircleClickListener mCircleClickListener;
    private float mDownX;
    private float mDownY;
    private int mTouchSlop;
    private boolean mFollowTouch = true;
    private NavigatorHelper mNavigatorHelper = new NavigatorHelper();
    private Interpolator mStartInterpolator = new LinearInterpolator();

    public ScaleCircleNavigator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMinRadius = UIUtil.dip2px((Context)context, (double)3.0);
        this.mMaxRadius = UIUtil.dip2px((Context)context, (double)5.0);
        this.mCircleSpacing = UIUtil.dip2px((Context)context, (double)8.0);
        this.mNavigatorHelper.setNavigatorScrollListener((NavigatorHelper.OnNavigatorScrollListener)this);
        this.mNavigatorHelper.setSkimOver(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = width;
                break;
            }
            case -2147483648: 
            case 0: {
                if (this.mCircleCount <= 0) {
                    result = this.getPaddingLeft() + this.getPaddingRight();
                    break;
                }
                result = (this.mCircleCount - 1) * this.mMinRadius * 2 + this.mMaxRadius * 2 + (this.mCircleCount - 1) * this.mCircleSpacing + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
        }
        return result;
    }

    private int measureHeight(int heightMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int result = 0;
        switch (mode) {
            case 0x40000000: {
                result = height;
                break;
            }
            case -2147483648: 
            case 0: {
                result = this.mMaxRadius * 2 + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        int j = this.mCirclePoints.size();
        for (int i = 0; i < j; ++i) {
            PointF point = this.mCirclePoints.get(i);
            float radius = ((Float)this.mCircleRadiusArray.get(i, (Object)Float.valueOf(this.mMinRadius))).floatValue();
            this.mPaint.setColor(ArgbEvaluatorHolder.eval((float)((radius - (float)this.mMinRadius) / (float)(this.mMaxRadius - this.mMinRadius)), (int)this.mNormalCircleColor, (int)this.mSelectedCircleColor));
            canvas.drawCircle(point.x, (float)this.getHeight() / 2.0f, radius, this.mPaint);
        }
    }

    private void prepareCirclePoints() {
        this.mCirclePoints.clear();
        if (this.mCircleCount > 0) {
            int y = Math.round((float)this.getHeight() / 2.0f);
            int centerSpacing = this.mMinRadius * 2 + this.mCircleSpacing;
            int startX = this.mMaxRadius + this.getPaddingLeft();
            for (int i = 0; i < this.mCircleCount; ++i) {
                PointF pointF = new PointF((float)startX, (float)y);
                this.mCirclePoints.add(pointF);
                startX += centerSpacing;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                if (!this.mTouchable) break;
                this.mDownX = x;
                this.mDownY = y;
                return true;
            }
            case 1: {
                if (this.mCircleClickListener == null || !(Math.abs(x - this.mDownX) <= (float)this.mTouchSlop) || !(Math.abs(y - this.mDownY) <= (float)this.mTouchSlop)) break;
                float max = Float.MAX_VALUE;
                int index = 0;
                for (int i = 0; i < this.mCirclePoints.size(); ++i) {
                    PointF pointF = this.mCirclePoints.get(i);
                    float offset = Math.abs(pointF.x - x);
                    if (!(offset < max)) continue;
                    max = offset;
                    index = i;
                }
                this.mCircleClickListener.onClick(index);
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mNavigatorHelper.onPageScrolled(position, positionOffset, positionOffsetPixels);
    }

    public void onPageSelected(int position) {
        this.mNavigatorHelper.onPageSelected(position);
    }

    public void onPageScrollStateChanged(int state) {
        this.mNavigatorHelper.onPageScrollStateChanged(state);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.prepareCirclePoints();
    }

    public void notifyDataSetChanged() {
        this.prepareCirclePoints();
        this.requestLayout();
    }

    public void onAttachToMagicIndicator() {
    }

    public void onDetachFromMagicIndicator() {
    }

    public void setMinRadius(int minRadius) {
        this.mMinRadius = minRadius;
        this.prepareCirclePoints();
        this.invalidate();
    }

    public void setMaxRadius(int maxRadius) {
        this.mMaxRadius = maxRadius;
        this.prepareCirclePoints();
        this.invalidate();
    }

    public void setNormalCircleColor(int normalCircleColor) {
        this.mNormalCircleColor = normalCircleColor;
        this.invalidate();
    }

    public void setSelectedCircleColor(int selectedCircleColor) {
        this.mSelectedCircleColor = selectedCircleColor;
        this.invalidate();
    }

    public void setCircleSpacing(int circleSpacing) {
        this.mCircleSpacing = circleSpacing;
        this.prepareCirclePoints();
        this.invalidate();
    }

    public void setStartInterpolator(Interpolator startInterpolator) {
        this.mStartInterpolator = startInterpolator;
        if (this.mStartInterpolator == null) {
            this.mStartInterpolator = new LinearInterpolator();
        }
    }

    public void setCircleCount(int count) {
        this.mCircleCount = count;
        this.mNavigatorHelper.setTotalCount(this.mCircleCount);
    }

    public void setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    public void setFollowTouch(boolean followTouch) {
        this.mFollowTouch = followTouch;
    }

    public void setSkimOver(boolean skimOver) {
        this.mNavigatorHelper.setSkimOver(skimOver);
    }

    public void setCircleClickListener(OnCircleClickListener circleClickListener) {
        if (!this.mTouchable) {
            this.mTouchable = true;
        }
        this.mCircleClickListener = circleClickListener;
    }

    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
        if (this.mFollowTouch) {
            float radius = (float)this.mMinRadius + (float)(this.mMaxRadius - this.mMinRadius) * this.mStartInterpolator.getInterpolation(enterPercent);
            this.mCircleRadiusArray.put(index, (Object)Float.valueOf(radius));
            this.invalidate();
        }
    }

    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
        if (this.mFollowTouch) {
            float radius = (float)this.mMaxRadius + (float)(this.mMinRadius - this.mMaxRadius) * this.mStartInterpolator.getInterpolation(leavePercent);
            this.mCircleRadiusArray.put(index, (Object)Float.valueOf(radius));
            this.invalidate();
        }
    }

    public void onSelected(int index, int totalCount) {
        if (!this.mFollowTouch) {
            this.mCircleRadiusArray.put(index, (Object)Float.valueOf(this.mMaxRadius));
            this.invalidate();
        }
    }

    public void onDeselected(int index, int totalCount) {
        if (!this.mFollowTouch) {
            this.mCircleRadiusArray.put(index, (Object)Float.valueOf(this.mMinRadius));
            this.invalidate();
        }
    }

    public static interface OnCircleClickListener {
        public void onClick(int var1);
    }
}

