/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vplayer.core;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultAllocator;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.gymchina.android.vplayer.JZMediaManager;
import com.gymchina.android.vplayer.JzvdMgr;
import com.gymchina.android.vplayer.R;
import com.gymchina.android.vplayer.core.JZMediaInterface;

public class JZExoPlayer
extends JZMediaInterface
implements Player.EventListener,
VideoListener {
    private SimpleExoPlayer simpleExoPlayer;
    private Handler mainHandler;
    private Runnable callback;
    private String TAG = "JZExoPlayer";
    private MediaSource videoSource;
    private long previousSeek = 0L;

    @Override
    public void start() {
        this.simpleExoPlayer.setPlayWhenReady(true);
    }

    @Override
    public void prepare() {
        Log.e((String)this.TAG, (String)"prepare");
        this.mainHandler = new Handler();
        Context context = JzvdMgr.getCurrentJzvd().getContext();
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        DefaultLoadControl loadControl = new DefaultLoadControl(new DefaultAllocator(true, 65536), 360000, 600000, 1000, 5000, -1, false);
        DefaultRenderersFactory renderersFactory = new DefaultRenderersFactory(context);
        this.simpleExoPlayer = ExoPlayerFactory.newSimpleInstance((RenderersFactory)renderersFactory, (TrackSelector)trackSelector, (LoadControl)loadControl);
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(context, Util.getUserAgent((Context)context, (String)context.getResources().getString(R.string.app_name)));
        String currUrl = this.jzDataSource.getCurrentUrl().toString();
        this.videoSource = currUrl.contains(".m3u8") ? new HlsMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)currUrl), this.mainHandler, null) : new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)currUrl));
        this.simpleExoPlayer.addVideoListener((VideoListener)this);
        Log.e((String)this.TAG, (String)("URL Link = " + currUrl));
        this.simpleExoPlayer.addListener((Player.EventListener)this);
        this.simpleExoPlayer.prepare(this.videoSource);
        this.simpleExoPlayer.setPlayWhenReady(true);
        this.callback = new onBufferingUpdate();
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        JZMediaManager.instance().currentVideoWidth = width;
        JZMediaManager.instance().currentVideoHeight = height;
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    JzvdMgr.getCurrentJzvd().onVideoSizeChanged();
                }
            }
        });
    }

    public void onRenderedFirstFrame() {
        Log.e((String)this.TAG, (String)"onRenderedFirstFrame");
    }

    @Override
    public void pause() {
        this.simpleExoPlayer.setPlayWhenReady(false);
    }

    @Override
    public boolean isPlaying() {
        return this.simpleExoPlayer.getPlayWhenReady();
    }

    @Override
    public void seekTo(long time) {
        if (time != this.previousSeek) {
            this.simpleExoPlayer.seekTo(time);
            this.previousSeek = time;
            JzvdMgr.getCurrentJzvd().seekToInAdvance = time;
        }
    }

    @Override
    public void release() {
        if (this.simpleExoPlayer != null) {
            this.simpleExoPlayer.release();
        }
        if (this.mainHandler != null) {
            this.mainHandler.removeCallbacks(this.callback);
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.simpleExoPlayer != null) {
            return this.simpleExoPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.simpleExoPlayer != null) {
            return this.simpleExoPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void setSurface(Surface surface) {
        this.simpleExoPlayer.setVideoSurface(surface);
        Log.e((String)this.TAG, (String)"setSurface");
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this.simpleExoPlayer.setVolume(leftVolume);
        this.simpleExoPlayer.setVolume(rightVolume);
    }

    public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {
        Log.e((String)this.TAG, (String)"onTimelineChanged");
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadingChanged(boolean isLoading) {
        Log.e((String)this.TAG, (String)"onLoadingChanged");
    }

    public void onPlayerStateChanged(final boolean playWhenReady, final int playbackState) {
        Log.e((String)this.TAG, (String)("onPlayerStateChanged" + playbackState + "/ready=" + String.valueOf(playWhenReady)));
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    switch (playbackState) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            JZExoPlayer.this.mainHandler.post(JZExoPlayer.this.callback);
                            break;
                        }
                        case 3: {
                            if (!playWhenReady) break;
                            JzvdMgr.getCurrentJzvd().onPrepared();
                            break;
                        }
                        case 4: {
                            JzvdMgr.getCurrentJzvd().onAutoCompletion();
                        }
                    }
                }
            }
        });
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
    }

    public void onPlayerError(ExoPlaybackException error) {
        Log.e((String)this.TAG, (String)("onPlayerError" + error.toString()));
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    JzvdMgr.getCurrentJzvd().onError(1000, 1000);
                }
            }
        });
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void onSeekProcessed() {
        JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    JzvdMgr.getCurrentJzvd().onSeekComplete();
                }
            }
        });
    }

    private class onBufferingUpdate
    implements Runnable {
        private onBufferingUpdate() {
        }

        @Override
        public void run() {
            final int percent = JZExoPlayer.this.simpleExoPlayer.getBufferedPercentage();
            JZMediaManager.instance().mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (JzvdMgr.getCurrentJzvd() != null) {
                        JzvdMgr.getCurrentJzvd().setBufferProgress(percent);
                    }
                }
            });
            if (percent < 100) {
                JZExoPlayer.this.mainHandler.postDelayed(JZExoPlayer.this.callback, 300L);
            } else {
                JZExoPlayer.this.mainHandler.removeCallbacks(JZExoPlayer.this.callback);
            }
        }
    }
}

