/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vplayer;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.gymchina.android.vplayer.JZDataSource;
import com.gymchina.android.vplayer.JZMediaManager;
import com.gymchina.android.vplayer.JZUtils;
import com.gymchina.android.vplayer.Jzvd;
import com.gymchina.android.vplayer.JzvdMgr;
import com.gymchina.android.vplayer.R;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class JzvdStd
extends Jzvd {
    protected static Timer DISMISS_CONTROL_VIEW_TIMER;
    public ImageView backButton;
    public ProgressBar bottomProgressBar;
    public ProgressBar loadingProgressBar;
    public TextView titleTextView;
    public ImageView thumbImageView;
    public ImageView tinyBackImageView;
    public LinearLayout batteryTimeLayout;
    public ImageView batteryLevel;
    public TextView videoCurrentTime;
    public TextView replayTextView;
    public TextView clarity;
    public PopupWindow clarityPopWindow;
    public TextView mRetryBtn;
    public LinearLayout mRetryLayout;
    protected DismissControlViewTimerTask mDismissControlViewTimerTask;
    protected Dialog mProgressDialog;
    protected ProgressBar mDialogProgressBar;
    protected TextView mDialogSeekTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected Dialog mVolumeDialog;
    protected ProgressBar mDialogVolumeProgressBar;
    protected TextView mDialogVolumeTextView;
    protected ImageView mDialogVolumeImageView;
    protected Dialog mBrightnessDialog;
    protected ProgressBar mDialogBrightnessProgressBar;
    protected TextView mDialogBrightnessTextView;
    public static long LAST_GET_BATTERYLEVEL_TIME;
    public static int LAST_GET_BATTERYLEVEL_PERCENT;
    private BroadcastReceiver battertReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                int percent;
                int level = intent.getIntExtra("level", 0);
                int scale = intent.getIntExtra("scale", 100);
                LAST_GET_BATTERYLEVEL_PERCENT = percent = level * 100 / scale;
                JzvdStd.this.setBatteryLevel();
                JzvdStd.this.getContext().unregisterReceiver(JzvdStd.this.battertReceiver);
            }
        }
    };

    public JzvdStd(Context context) {
        super(context);
    }

    public JzvdStd(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void init(Context context) {
        super.init(context);
        this.batteryTimeLayout = (LinearLayout)this.findViewById(R.id.battery_time_layout);
        this.bottomProgressBar = (ProgressBar)this.findViewById(R.id.bottom_progress);
        this.titleTextView = (TextView)this.findViewById(R.id.title);
        this.backButton = (ImageView)this.findViewById(R.id.back);
        this.thumbImageView = (ImageView)this.findViewById(R.id.thumb);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loading);
        this.tinyBackImageView = (ImageView)this.findViewById(R.id.back_tiny);
        this.batteryLevel = (ImageView)this.findViewById(R.id.battery_level);
        this.videoCurrentTime = (TextView)this.findViewById(R.id.video_current_time);
        this.replayTextView = (TextView)this.findViewById(R.id.replay_text);
        this.clarity = (TextView)this.findViewById(R.id.clarity);
        this.mRetryBtn = (TextView)this.findViewById(R.id.retry_btn);
        this.mRetryLayout = (LinearLayout)this.findViewById(R.id.retry_layout);
        this.thumbImageView.setOnClickListener((View.OnClickListener)this);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.tinyBackImageView.setOnClickListener((View.OnClickListener)this);
        this.clarity.setOnClickListener((View.OnClickListener)this);
        this.mRetryBtn.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setUp(JZDataSource jzDataSource, int screen) {
        super.setUp(jzDataSource, screen);
        this.titleTextView.setText((CharSequence)jzDataSource.title);
        if (this.currentScreen == 2) {
            this.fullscreenButton.setImageResource(R.drawable.jz_shrink);
            this.backButton.setVisibility(0);
            this.tinyBackImageView.setVisibility(4);
            this.batteryTimeLayout.setVisibility(0);
            if (jzDataSource.urlsMap.size() == 1) {
                this.clarity.setVisibility(8);
            } else {
                this.clarity.setText((CharSequence)jzDataSource.getCurrentKey().toString());
                this.clarity.setVisibility(0);
            }
            this.changeStartButtonSize((int)this.getResources().getDimension(R.dimen.jz_start_button_w_h_fullscreen));
        } else if (this.currentScreen == 0 || this.currentScreen == 1) {
            this.fullscreenButton.setImageResource(R.drawable.jz_enlarge);
            this.backButton.setVisibility(8);
            this.tinyBackImageView.setVisibility(4);
            this.changeStartButtonSize((int)this.getResources().getDimension(R.dimen.jz_start_button_w_h_normal));
            this.batteryTimeLayout.setVisibility(8);
            this.clarity.setVisibility(8);
        } else if (this.currentScreen == 3) {
            this.tinyBackImageView.setVisibility(0);
            this.setAllControlsVisiblity(4, 4, 4, 4, 4, 4, 4);
            this.batteryTimeLayout.setVisibility(8);
            this.clarity.setVisibility(8);
        }
        this.setSystemTimeAndBattery();
        if (this.tmp_test_back) {
            this.tmp_test_back = false;
            JzvdMgr.setFirstFloor(this);
            JzvdStd.backPress();
        }
    }

    public void changeStartButtonSize(int size) {
        ViewGroup.LayoutParams lp = this.startButton.getLayoutParams();
        lp.height = size;
        lp.width = size;
        lp = this.loadingProgressBar.getLayoutParams();
        lp.height = size;
        lp.width = size;
    }

    @Override
    public int getLayoutId() {
        return R.layout.jz_layout_standard;
    }

    @Override
    public void onStateNormal() {
        super.onStateNormal();
        this.changeUiToNormal();
    }

    @Override
    public void onStatePreparing() {
        super.onStatePreparing();
        this.changeUiToPreparing();
    }

    @Override
    public void changeUrl(int urlMapIndex, long seekToInAdvance) {
        super.changeUrl(urlMapIndex, seekToInAdvance);
        this.loadingProgressBar.setVisibility(0);
        this.startButton.setVisibility(4);
    }

    @Override
    public void changeUrl(JZDataSource jzDataSource, long seekToInAdvance) {
        super.changeUrl(jzDataSource, seekToInAdvance);
        this.titleTextView.setText((CharSequence)jzDataSource.title);
        this.loadingProgressBar.setVisibility(0);
        this.startButton.setVisibility(4);
    }

    @Override
    public void onStatePlaying() {
        super.onStatePlaying();
        this.changeUiToPlayingClear();
    }

    @Override
    public void onStatePause() {
        super.onStatePause();
        this.changeUiToPauseShow();
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onStateError() {
        super.onStateError();
        this.changeUiToError();
    }

    @Override
    public void onStateAutoComplete() {
        super.onStateAutoComplete();
        this.changeUiToComplete();
        this.cancelDismissControlViewTimer();
        this.bottomProgressBar.setProgress(100);
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    if (this.mChangePosition) {
                        long duration = this.getDuration();
                        int progress = (int)(this.mSeekTimePosition * 100L / (duration == 0L ? 1L : duration));
                        this.bottomProgressBar.setProgress(progress);
                    }
                    if (this.mChangePosition || this.mChangeVolume) break;
                    this.onEvent(102);
                    this.onClickUiToggle();
                }
            }
        } else if (id2 == R.id.bottom_seek_progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                }
            }
        }
        return super.onTouch(v, event);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int i = v.getId();
        if (i == R.id.thumb) {
            if (this.jzDataSource.urlsMap.isEmpty() || this.jzDataSource.getCurrentUrl() == null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.currentState == 0) {
                if (!(this.jzDataSource.getCurrentUrl().toString().startsWith("file") || this.jzDataSource.getCurrentUrl().toString().startsWith("/") || JZUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.startVideo();
                this.onEvent(101);
            } else if (this.currentState == 6) {
                this.onClickUiToggle();
            }
        } else if (i == R.id.surface_container) {
            this.startDismissControlViewTimer();
        } else if (i == R.id.back) {
            JzvdStd.backPress();
        } else if (i == R.id.back_tiny) {
            if (JzvdMgr.getFirstFloor().currentScreen == 1) {
                JzvdStd.quitFullscreenOrTinyWindow();
            } else {
                JzvdStd.backPress();
            }
        } else if (i == R.id.clarity) {
            LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            final LinearLayout layout2 = (LinearLayout)inflater.inflate(R.layout.jz_layout_clarity, null);
            View.OnClickListener mQualityListener = new View.OnClickListener(){

                public void onClick(View v) {
                    int index = (Integer)v.getTag();
                    JzvdStd.this.changeUrl(index, JzvdStd.this.getCurrentPositionWhenPlaying());
                    JzvdStd.this.clarity.setText((CharSequence)JzvdStd.this.jzDataSource.getCurrentKey().toString());
                    for (int j = 0; j < layout2.getChildCount(); ++j) {
                        if (j == JzvdStd.this.jzDataSource.currentUrlIndex) {
                            ((TextView)layout2.getChildAt(j)).setTextColor(Color.parseColor((String)"#fff85959"));
                            continue;
                        }
                        ((TextView)layout2.getChildAt(j)).setTextColor(Color.parseColor((String)"#ffffff"));
                    }
                    if (JzvdStd.this.clarityPopWindow != null) {
                        JzvdStd.this.clarityPopWindow.dismiss();
                    }
                }
            };
            for (int j = 0; j < this.jzDataSource.urlsMap.size(); ++j) {
                String key = this.jzDataSource.getKeyFromDataSource(j);
                TextView clarityItem = (TextView)View.inflate((Context)this.getContext(), (int)R.layout.jz_layout_clarity_item, null);
                clarityItem.setText((CharSequence)key);
                clarityItem.setTag((Object)j);
                layout2.addView((View)clarityItem, j);
                clarityItem.setOnClickListener(mQualityListener);
                if (j != this.jzDataSource.currentUrlIndex) continue;
                clarityItem.setTextColor(Color.parseColor((String)"#fff85959"));
            }
            this.clarityPopWindow = new PopupWindow((View)layout2, -2, -2, true);
            this.clarityPopWindow.setContentView((View)layout2);
            this.clarityPopWindow.showAsDropDown((View)this.clarity);
            layout2.measure(0, 0);
            int offsetX = this.clarity.getMeasuredWidth() / 3;
            int offsetY = this.clarity.getMeasuredHeight() / 3;
            this.clarityPopWindow.update((View)this.clarity, -offsetX, -offsetY, Math.round(layout2.getMeasuredWidth() * 2), layout2.getMeasuredHeight());
        } else if (i == R.id.retry_btn) {
            if (this.jzDataSource.urlsMap.isEmpty() || this.jzDataSource.getCurrentUrl() == null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (!(this.jzDataSource.getCurrentUrl().toString().startsWith("file") || this.jzDataSource.getCurrentUrl().toString().startsWith("/") || JZUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                this.showWifiDialog();
                return;
            }
            this.initTextureView();
            this.addTextureView();
            JZMediaManager.setDataSource(this.jzDataSource);
            this.onStatePreparing();
            this.onEvent(1);
        }
    }

    @Override
    public void showWifiDialog() {
        super.showWifiDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_wifi));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                JzvdStd.this.onEvent(103);
                JzvdStd.this.startVideo();
                Jzvd.WIFI_TIP_DIALOG_SHOWED = true;
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                JzvdStd.this.clearFloatScreen();
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        super.onStartTrackingTouch(seekBar);
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        super.onStopTrackingTouch(seekBar);
        this.startDismissControlViewTimer();
    }

    public void onClickUiToggle() {
        if (this.bottomContainer.getVisibility() != 0) {
            this.setSystemTimeAndBattery();
            this.clarity.setText((CharSequence)this.jzDataSource.getCurrentKey().toString());
        }
        if (this.currentState == 1) {
            this.changeUiToPreparing();
            if (this.bottomContainer.getVisibility() != 0) {
                this.setSystemTimeAndBattery();
            }
        } else if (this.currentState == 3) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingClear();
            } else {
                this.changeUiToPlayingShow();
            }
        } else if (this.currentState == 5) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPauseClear();
            } else {
                this.changeUiToPauseShow();
            }
        }
    }

    public void setSystemTimeAndBattery() {
        SimpleDateFormat dateFormater = new SimpleDateFormat("HH:mm");
        Date date = new Date();
        this.videoCurrentTime.setText((CharSequence)dateFormater.format(date));
        if (System.currentTimeMillis() - LAST_GET_BATTERYLEVEL_TIME > 30000L) {
            LAST_GET_BATTERYLEVEL_TIME = System.currentTimeMillis();
            this.getContext().registerReceiver(this.battertReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        } else {
            this.setBatteryLevel();
        }
    }

    public void setBatteryLevel() {
        int percent = LAST_GET_BATTERYLEVEL_PERCENT;
        if (percent < 15) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_10);
        } else if (percent >= 15 && percent < 40) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_30);
        } else if (percent >= 40 && percent < 60) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_50);
        } else if (percent >= 60 && percent < 80) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_70);
        } else if (percent >= 80 && percent < 95) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_90);
        } else if (percent >= 95 && percent <= 100) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_100);
        }
    }

    public void onCLickUiToggleToClear() {
        if (this.currentState == 1) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPreparing();
            }
        } else if (this.currentState == 3) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingClear();
            }
        } else if (this.currentState == 5) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPauseClear();
            }
        } else if (this.currentState == 6 && this.bottomContainer.getVisibility() == 0) {
            this.changeUiToComplete();
        }
    }

    @Override
    public void onProgress(int progress, long position, long duration) {
        super.onProgress(progress, position, duration);
        if (progress != 0) {
            this.bottomProgressBar.setProgress(progress);
        }
    }

    @Override
    public void setBufferProgress(int bufferProgress) {
        super.setBufferProgress(bufferProgress);
        if (bufferProgress != 0) {
            this.bottomProgressBar.setSecondaryProgress(bufferProgress);
        }
    }

    @Override
    public void resetProgressAndTime() {
        super.resetProgressAndTime();
        this.bottomProgressBar.setProgress(0);
        this.bottomProgressBar.setSecondaryProgress(0);
    }

    public void changeUiToNormal() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPreparing() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 0, 0, 4, 4);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(4, 4, 4, 0, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPlayingShow() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPlayingClear() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
        }
    }

    public void changeUiToPauseShow() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPauseClear() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
        }
    }

    public void changeUiToComplete() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToError() {
        switch (this.currentScreen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 0, 4, 4, 4, 0);
                this.updateStartImage();
                break;
            }
            case 2: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 4, 4, 0);
                this.updateStartImage();
                break;
            }
        }
    }

    public void setAllControlsVisiblity(int topCon, int bottomCon, int startBtn, int loadingPro, int thumbImg, int bottomPro, int retryLayout) {
        this.topContainer.setVisibility(topCon);
        this.bottomContainer.setVisibility(bottomCon);
        this.startButton.setVisibility(startBtn);
        this.loadingProgressBar.setVisibility(loadingPro);
        this.thumbImageView.setVisibility(thumbImg);
        this.bottomProgressBar.setVisibility(bottomPro);
        this.mRetryLayout.setVisibility(retryLayout);
    }

    public void updateStartImage() {
        if (this.currentState == 3) {
            this.startButton.setVisibility(0);
            this.startButton.setImageResource(R.drawable.jz_click_pause_selector);
            this.replayTextView.setVisibility(4);
        } else if (this.currentState == 7) {
            this.startButton.setVisibility(4);
            this.replayTextView.setVisibility(4);
        } else if (this.currentState == 6) {
            this.startButton.setVisibility(0);
            this.startButton.setImageResource(R.drawable.jz_click_replay_selector);
            this.replayTextView.setVisibility(0);
        } else {
            this.startButton.setImageResource(R.drawable.jz_click_play_selector);
            this.replayTextView.setVisibility(4);
        }
    }

    @Override
    public void showProgressDialog(float deltaX, String seekTime, long seekTimePosition, String totalTime, long totalTimeDuration) {
        super.showProgressDialog(deltaX, seekTime, seekTimePosition, totalTime, totalTimeDuration);
        if (this.mProgressDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jz_dialog_progress, null);
            this.mDialogProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.mDialogSeekTime = (TextView)localView.findViewById(R.id.tv_current);
            this.mDialogTotalTime = (TextView)localView.findViewById(R.id.tv_duration);
            this.mDialogIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.mProgressDialog = this.createDialogWithView(localView);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        this.mDialogSeekTime.setText((CharSequence)seekTime);
        this.mDialogTotalTime.setText((CharSequence)(" / " + totalTime));
        this.mDialogProgressBar.setProgress(totalTimeDuration <= 0L ? 0 : (int)(seekTimePosition * 100L / totalTimeDuration));
        if (deltaX > 0.0f) {
            this.mDialogIcon.setBackgroundResource(R.drawable.jz_forward_icon);
        } else {
            this.mDialogIcon.setBackgroundResource(R.drawable.jz_backward_icon);
        }
        this.onCLickUiToggleToClear();
    }

    @Override
    public void dismissProgressDialog() {
        super.dismissProgressDialog();
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    @Override
    public void showVolumeDialog(float deltaY, int volumePercent) {
        super.showVolumeDialog(deltaY, volumePercent);
        if (this.mVolumeDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jz_dialog_volume, null);
            this.mDialogVolumeImageView = (ImageView)localView.findViewById(R.id.volume_image_tip);
            this.mDialogVolumeTextView = (TextView)localView.findViewById(R.id.tv_volume);
            this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.mVolumeDialog = this.createDialogWithView(localView);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        if (volumePercent <= 0) {
            this.mDialogVolumeImageView.setBackgroundResource(R.drawable.jz_close_volume);
        } else {
            this.mDialogVolumeImageView.setBackgroundResource(R.drawable.jz_add_volume);
        }
        if (volumePercent > 100) {
            volumePercent = 100;
        } else if (volumePercent < 0) {
            volumePercent = 0;
        }
        this.mDialogVolumeTextView.setText((CharSequence)(volumePercent + "%"));
        this.mDialogVolumeProgressBar.setProgress(volumePercent);
        this.onCLickUiToggleToClear();
    }

    @Override
    public void dismissVolumeDialog() {
        super.dismissVolumeDialog();
        if (this.mVolumeDialog != null) {
            this.mVolumeDialog.dismiss();
        }
    }

    @Override
    public void showBrightnessDialog(int brightnessPercent) {
        super.showBrightnessDialog(brightnessPercent);
        if (this.mBrightnessDialog == null) {
            View localView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.jz_dialog_brightness, null);
            this.mDialogBrightnessTextView = (TextView)localView.findViewById(R.id.tv_brightness);
            this.mDialogBrightnessProgressBar = (ProgressBar)localView.findViewById(R.id.brightness_progressbar);
            this.mBrightnessDialog = this.createDialogWithView(localView);
        }
        if (!this.mBrightnessDialog.isShowing()) {
            this.mBrightnessDialog.show();
        }
        if (brightnessPercent > 100) {
            brightnessPercent = 100;
        } else if (brightnessPercent < 0) {
            brightnessPercent = 0;
        }
        this.mDialogBrightnessTextView.setText((CharSequence)(brightnessPercent + "%"));
        this.mDialogBrightnessProgressBar.setProgress(brightnessPercent);
        this.onCLickUiToggleToClear();
    }

    @Override
    public void dismissBrightnessDialog() {
        super.dismissBrightnessDialog();
        if (this.mBrightnessDialog != null) {
            this.mBrightnessDialog.dismiss();
        }
    }

    public Dialog createDialogWithView(View localView) {
        Dialog dialog = new Dialog(this.getContext(), R.style.jz_style_dialog_progress);
        dialog.setContentView(localView);
        Window window = dialog.getWindow();
        window.addFlags(8);
        window.addFlags(32);
        window.addFlags(16);
        window.setLayout(-2, -2);
        WindowManager.LayoutParams localLayoutParams = window.getAttributes();
        localLayoutParams.gravity = 17;
        window.setAttributes(localLayoutParams);
        return dialog;
    }

    public void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        DISMISS_CONTROL_VIEW_TIMER = new Timer();
        this.mDismissControlViewTimerTask = new DismissControlViewTimerTask();
        DISMISS_CONTROL_VIEW_TIMER.schedule((TimerTask)this.mDismissControlViewTimerTask, 2500L);
    }

    public void cancelDismissControlViewTimer() {
        if (DISMISS_CONTROL_VIEW_TIMER != null) {
            DISMISS_CONTROL_VIEW_TIMER.cancel();
        }
        if (this.mDismissControlViewTimerTask != null) {
            this.mDismissControlViewTimerTask.cancel();
        }
    }

    @Override
    public void onAutoCompletion() {
        super.onAutoCompletion();
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onCompletion() {
        super.onCompletion();
        this.cancelDismissControlViewTimer();
        if (this.clarityPopWindow != null) {
            this.clarityPopWindow.dismiss();
        }
    }

    public void dissmissControlView() {
        if (this.currentState != 0 && this.currentState != 7 && this.currentState != 6) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    JzvdStd.this.bottomContainer.setVisibility(4);
                    JzvdStd.this.topContainer.setVisibility(4);
                    JzvdStd.this.startButton.setVisibility(4);
                    if (JzvdStd.this.clarityPopWindow != null) {
                        JzvdStd.this.clarityPopWindow.dismiss();
                    }
                    if (JzvdStd.this.currentScreen != 3) {
                        JzvdStd.this.bottomProgressBar.setVisibility(0);
                    }
                }
            });
        }
    }

    static {
        LAST_GET_BATTERYLEVEL_TIME = 0L;
        LAST_GET_BATTERYLEVEL_PERCENT = 70;
    }

    public class DismissControlViewTimerTask
    extends TimerTask {
        @Override
        public void run() {
            JzvdStd.this.dissmissControlView();
        }
    }
}

