/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vplayer;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ContextThemeWrapper;
import android.util.Log;
import android.view.Window;
import com.gymchina.android.vplayer.Jzvd;
import java.util.Formatter;
import java.util.Locale;

public class JZUtils {
    public static final String TAG = "JZVD";

    public static String stringForTime(long timeMs) {
        if (timeMs <= 0L || timeMs >= 86400000L) {
            return "00:00";
        }
        long totalSeconds = timeMs / 1000L;
        int seconds = (int)(totalSeconds % 60L);
        int minutes = (int)(totalSeconds / 60L % 60L);
        int hours = (int)(totalSeconds / 3600L);
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return JZUtils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return JZUtils.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    public static void setRequestedOrientation(Context context, int orientation) {
        if (JZUtils.getAppCompActivity(context) != null) {
            JZUtils.getAppCompActivity(context).setRequestedOrientation(orientation);
        } else {
            JZUtils.scanForActivity(context).setRequestedOrientation(orientation);
        }
    }

    public static Window getWindow(Context context) {
        if (JZUtils.getAppCompActivity(context) != null) {
            return JZUtils.getAppCompActivity(context).getWindow();
        }
        return JZUtils.scanForActivity(context).getWindow();
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static void saveProgress(Context context, Object url, long progress) {
        if (!Jzvd.SAVE_PROGRESS) {
            return;
        }
        Log.i((String)TAG, (String)("saveProgress: " + progress));
        if (progress < 5000L) {
            progress = 0L;
        }
        SharedPreferences spn = context.getSharedPreferences("JZVD_PROGRESS", 0);
        SharedPreferences.Editor editor = spn.edit();
        editor.putLong("newVersion:" + url.toString(), progress).apply();
    }

    public static long getSavedProgress(Context context, Object url) {
        if (!Jzvd.SAVE_PROGRESS) {
            return 0L;
        }
        SharedPreferences spn = context.getSharedPreferences("JZVD_PROGRESS", 0);
        return spn.getLong("newVersion:" + url.toString(), 0L);
    }

    public static void clearSavedProgress(Context context, Object url) {
        if (url == null) {
            SharedPreferences spn = context.getSharedPreferences("JZVD_PROGRESS", 0);
            spn.edit().clear().apply();
        } else {
            SharedPreferences spn = context.getSharedPreferences("JZVD_PROGRESS", 0);
            spn.edit().putLong("newVersion:" + url.toString(), 0L).apply();
        }
    }
}

