/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vplayer;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import com.gymchina.android.vplayer.JZDataSource;
import com.gymchina.android.vplayer.JZTextureView;
import com.gymchina.android.vplayer.JzvdMgr;
import com.gymchina.android.vplayer.core.JZMediaInterface;
import com.gymchina.android.vplayer.core.JZMediaSystem;

public class JZMediaManager
implements TextureView.SurfaceTextureListener {
    public static final String TAG = "JZVD";
    public static final int HANDLER_PREPARE = 0;
    public static final int HANDLER_RELEASE = 2;
    public static JZTextureView textureView;
    public static SurfaceTexture savedSurfaceTexture;
    public static Surface surface;
    public static JZMediaManager jzMediaManager;
    public int positionInList = -1;
    public JZMediaInterface jzMediaInterface;
    public int currentVideoWidth = 0;
    public int currentVideoHeight = 0;
    public HandlerThread mMediaHandlerThread = new HandlerThread("JZVD");
    public MediaHandler mMediaHandler;
    public Handler mainThreadHandler;

    public JZMediaManager() {
        this.mMediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(this.mMediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
        if (this.jzMediaInterface == null) {
            this.jzMediaInterface = new JZMediaSystem();
        }
    }

    public static JZMediaManager instance() {
        if (jzMediaManager == null) {
            jzMediaManager = new JZMediaManager();
        }
        return jzMediaManager;
    }

    public static void setDataSource(JZDataSource jzDataSource) {
        JZMediaManager.instance().jzMediaInterface.jzDataSource = jzDataSource;
    }

    public static JZDataSource getDataSource() {
        return JZMediaManager.instance().jzMediaInterface.jzDataSource;
    }

    public static Object getCurrentUrl() {
        return JZMediaManager.instance().jzMediaInterface.jzDataSource == null ? null : JZMediaManager.instance().jzMediaInterface.jzDataSource.getCurrentUrl();
    }

    public static long getCurrentPosition() {
        return JZMediaManager.instance().jzMediaInterface.getCurrentPosition();
    }

    public static long getDuration() {
        return JZMediaManager.instance().jzMediaInterface.getDuration();
    }

    public static void seekTo(long time) {
        JZMediaManager.instance().jzMediaInterface.seekTo(time);
    }

    public static void pause() {
        JZMediaManager.instance().jzMediaInterface.pause();
    }

    public static void start() {
        JZMediaManager.instance().jzMediaInterface.start();
    }

    public static boolean isPlaying() {
        return JZMediaManager.instance().jzMediaInterface.isPlaying();
    }

    public void releaseMediaPlayer() {
        this.mMediaHandler.removeCallbacksAndMessages(null);
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
    }

    public void prepare() {
        this.releaseMediaPlayer();
        Message msg = new Message();
        msg.what = 0;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i1) {
        if (JzvdMgr.getCurrentJzvd() == null) {
            return;
        }
        Log.i((String)TAG, (String)("onSurfaceTextureAvailable [" + JzvdMgr.getCurrentJzvd().hashCode() + "] "));
        if (savedSurfaceTexture == null) {
            savedSurfaceTexture = surfaceTexture;
            this.prepare();
        } else {
            textureView.setSurfaceTexture(savedSurfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i1) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return savedSurfaceTexture == null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public class MediaHandler
    extends Handler {
        public MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    JZMediaManager.this.currentVideoWidth = 0;
                    JZMediaManager.this.currentVideoHeight = 0;
                    JZMediaManager.this.jzMediaInterface.prepare();
                    if (savedSurfaceTexture == null) break;
                    if (surface != null) {
                        surface.release();
                    }
                    surface = new Surface(savedSurfaceTexture);
                    JZMediaManager.this.jzMediaInterface.setSurface(surface);
                    break;
                }
                case 2: {
                    JZMediaManager.this.jzMediaInterface.release();
                }
            }
        }
    }
}

