/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.processor;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.v7.widget.RecyclerView;
import android.view.animation.DecelerateInterpolator;
import com.gymchina.android.vrefresh.VerticalRefreshLayout;
import com.gymchina.android.vrefresh.processor.IAnimOverScroll;
import com.gymchina.android.vrefresh.processor.IAnimRefresh;
import com.gymchina.android.vrefresh.utils.ScrollingUtil;

public class AnimProcessor
implements IAnimRefresh,
IAnimOverScroll {
    private VerticalRefreshLayout.CoContext cp;
    private static final float animFraction = 1.0f;
    private DecelerateInterpolator decelerateInterpolator;
    private boolean isAnimHeadToRefresh = false;
    private boolean isAnimHeadBack = false;
    private boolean isAnimBottomToLoad = false;
    private boolean isAnimBottomBack = false;
    private boolean isAnimHeadHide = false;
    private boolean isAnimBottomHide = false;
    private boolean isAnimOsTop = false;
    private boolean isOverScrollTopLocked = false;
    private boolean isAnimOsBottom = false;
    private boolean isOverScrollBottomLocked = false;
    private ValueAnimator.AnimatorUpdateListener animHeadUpListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int height;
            ((AnimProcessor)AnimProcessor.this).cp.getHeader().getLayoutParams().height = height = ((Integer)animation.getAnimatedValue()).intValue();
            AnimProcessor.this.cp.getHeader().requestLayout();
            if (!AnimProcessor.this.cp.isOpenFloatRefresh()) {
                AnimProcessor.this.cp.getTargetView().setTranslationY((float)height);
                AnimProcessor.this.translateExHead(height);
            }
            AnimProcessor.this.cp.onPullDownReleasing(height);
        }
    };
    private ValueAnimator.AnimatorUpdateListener animBottomUpListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int height;
            ((AnimProcessor)AnimProcessor.this).cp.getFooter().getLayoutParams().height = height = ((Integer)animation.getAnimatedValue()).intValue();
            AnimProcessor.this.cp.getFooter().requestLayout();
            AnimProcessor.this.cp.getTargetView().setTranslationY((float)(-height));
            AnimProcessor.this.cp.onPullUpReleasing(height);
        }
    };
    private ValueAnimator.AnimatorUpdateListener overScrollTopUpListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int height = (Integer)animation.getAnimatedValue();
            if (AnimProcessor.this.cp.isOverScrollTopShow()) {
                ((AnimProcessor)AnimProcessor.this).cp.getHeader().getLayoutParams().height = height;
                AnimProcessor.this.cp.getHeader().requestLayout();
            } else {
                AnimProcessor.this.cp.getHeader().setVisibility(8);
            }
            AnimProcessor.this.cp.getTargetView().setTranslationY((float)height);
            AnimProcessor.this.translateExHead(height);
            AnimProcessor.this.cp.onPullDownReleasing(height);
        }
    };
    private ValueAnimator.AnimatorUpdateListener overScrollBottomUpListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int height = (Integer)animation.getAnimatedValue();
            if (AnimProcessor.this.cp.isOverScrollBottomShow()) {
                ((AnimProcessor)AnimProcessor.this).cp.getFooter().getLayoutParams().height = height;
                AnimProcessor.this.cp.getFooter().requestLayout();
            } else {
                AnimProcessor.this.cp.getFooter().setVisibility(8);
            }
            AnimProcessor.this.cp.getTargetView().setTranslationY((float)(-height));
            AnimProcessor.this.cp.onPullUpReleasing(height);
        }
    };

    public AnimProcessor(VerticalRefreshLayout.CoContext coProcessor) {
        this.cp = coProcessor;
        this.decelerateInterpolator = new DecelerateInterpolator(8.0f);
    }

    @Override
    public void scrollHeadByMove(float moveY) {
        float offsetY = this.decelerateInterpolator.getInterpolation(moveY / this.cp.getMaxHeadHeight() / 2.0f) * moveY / 2.0f;
        if (this.cp.getHeader().getVisibility() != 0) {
            this.cp.getHeader().setVisibility(0);
        }
        if (this.cp.isPureScrollModeOn()) {
            this.cp.getHeader().setVisibility(8);
        }
        this.cp.getHeader().getLayoutParams().height = (int)Math.abs(offsetY);
        this.cp.getHeader().requestLayout();
        if (!this.cp.isOpenFloatRefresh()) {
            this.cp.getTargetView().setTranslationY(offsetY);
            this.translateExHead((int)offsetY);
        }
        this.cp.onPullingDown(offsetY);
    }

    @Override
    public void scrollBottomByMove(float moveY) {
        float offsetY = this.decelerateInterpolator.getInterpolation(moveY / (float)this.cp.getMaxBottomHeight() / 2.0f) * moveY / 2.0f;
        if (this.cp.getFooter().getVisibility() != 0) {
            this.cp.getFooter().setVisibility(0);
        }
        if (this.cp.isPureScrollModeOn()) {
            this.cp.getFooter().setVisibility(8);
        }
        this.cp.getFooter().getLayoutParams().height = (int)Math.abs(offsetY);
        this.cp.getFooter().requestLayout();
        this.cp.getTargetView().setTranslationY(-offsetY);
        this.cp.onPullingUp(-offsetY);
    }

    public void dealPullDownRelease() {
        if (!this.cp.isPureScrollModeOn() && this.cp.enableRefresh() && this.getVisibleHeadHeight() >= this.cp.getHeadHeight() - this.cp.getTouchSlop()) {
            this.animHeadToRefresh();
        } else {
            this.animHeadBack();
        }
    }

    public void dealPullUpRelease() {
        if (!this.cp.isPureScrollModeOn() && this.cp.enableLoadmore() && this.getVisibleFootHeight() >= this.cp.getBottomHeight() - this.cp.getTouchSlop()) {
            this.animBottomToLoad();
        } else {
            this.animBottomBack();
        }
    }

    private int getVisibleHeadHeight() {
        return this.cp.getHeader().getLayoutParams().height;
    }

    private int getVisibleFootHeight() {
        return this.cp.getFooter().getLayoutParams().height;
    }

    @Override
    public void animHeadToRefresh() {
        this.isAnimHeadToRefresh = true;
        this.animLayoutByTime(this.getVisibleHeadHeight(), this.cp.getHeadHeight(), this.animHeadUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimHeadToRefresh = false;
                AnimProcessor.this.cp.setRefreshing(true);
                AnimProcessor.this.cp.onRefresh();
            }
        });
    }

    @Override
    public void animHeadBack() {
        this.isAnimHeadBack = true;
        this.animLayoutByTime(this.getVisibleHeadHeight(), 0, this.animHeadUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimHeadBack = false;
            }
        });
    }

    @Override
    public void animBottomToLoad() {
        this.isAnimBottomToLoad = true;
        this.animLayoutByTime(this.getVisibleFootHeight(), this.cp.getBottomHeight(), this.animBottomUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimBottomToLoad = false;
                AnimProcessor.this.cp.setLoadingMore(true);
                AnimProcessor.this.cp.onLoadMore();
            }
        });
    }

    @Override
    public void animBottomBack() {
        this.isAnimBottomBack = true;
        this.animLayoutByTime(this.getVisibleFootHeight(), 0, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int dy;
                if (!ScrollingUtil.isViewToBottom(AnimProcessor.this.cp.getTargetView(), AnimProcessor.this.cp.getTouchSlop()) && (dy = AnimProcessor.this.getVisibleFootHeight() - (Integer)animation.getAnimatedValue()) > 0) {
                    if (AnimProcessor.this.cp.getTargetView() instanceof RecyclerView) {
                        ScrollingUtil.scrollAViewBy(AnimProcessor.this.cp.getTargetView(), dy);
                    } else {
                        ScrollingUtil.scrollAViewBy(AnimProcessor.this.cp.getTargetView(), dy / 2);
                    }
                }
                AnimProcessor.this.animBottomUpListener.onAnimationUpdate(animation);
            }
        }, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimBottomBack = false;
            }
        });
    }

    @Override
    public void animHeadHideByVy(int vy) {
        this.isAnimHeadHide = true;
        this.cp.onRefreshCanceled();
        vy = Math.abs(vy);
        if (vy < 5000) {
            vy = 8000;
        }
        this.animLayoutByTime(this.getVisibleHeadHeight(), 0, 5 * Math.abs(this.getVisibleHeadHeight() * 1000 / vy), this.animHeadUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimHeadHide = false;
                AnimProcessor.this.cp.resetHeaderView();
            }
        });
    }

    @Override
    public void animBottomHideByVy(int vy) {
        this.isAnimBottomHide = true;
        this.cp.onLoadmoreCanceled();
        vy = Math.abs(vy);
        if (vy < 5000) {
            vy = 8000;
        }
        this.animLayoutByTime(this.getVisibleFootHeight(), 0, 5 * this.getVisibleFootHeight() * 1000 / vy, this.animBottomUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.isAnimBottomHide = false;
                AnimProcessor.this.cp.resetBottomView();
            }
        });
    }

    @Override
    public void animOverScrollTop(float vy, int computeTimes) {
        if (this.isOverScrollTopLocked) {
            return;
        }
        this.isOverScrollTopLocked = true;
        this.isAnimOsTop = true;
        this.cp.setStatePTD();
        int oh = (int)Math.abs(vy / (float)computeTimes / 2.0f);
        final int overHeight = oh > this.cp.getOsHeight() ? this.cp.getOsHeight() : oh;
        final int time = overHeight <= 50 ? 115 : (int)(0.3 * (double)overHeight + 100.0);
        this.animLayoutByTime(0, overHeight, time, this.overScrollTopUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AnimProcessor.this.animLayoutByTime(overHeight, 0, 2 * time, AnimProcessor.this.overScrollTopUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        AnimProcessor.this.isAnimOsTop = false;
                        AnimProcessor.this.isOverScrollTopLocked = false;
                    }
                });
            }
        });
    }

    @Override
    public void animOverScrollBottom(float vy, int computeTimes) {
        int time;
        if (this.isOverScrollBottomLocked) {
            return;
        }
        this.cp.setStatePBU();
        int oh = (int)Math.abs(vy / (float)computeTimes / 2.0f);
        final int overHeight = oh > this.cp.getOsHeight() ? this.cp.getOsHeight() : oh;
        int n = time = overHeight <= 50 ? 115 : (int)(0.3 * (double)overHeight + 100.0);
        if (this.cp.autoLoadMore()) {
            this.cp.startLoadMore();
        } else {
            this.isOverScrollBottomLocked = true;
            this.isAnimOsBottom = true;
            this.animLayoutByTime(0, overHeight, time, this.overScrollBottomUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    AnimProcessor.this.animLayoutByTime(overHeight, 0, 2 * time, AnimProcessor.this.overScrollBottomUpListener, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            AnimProcessor.this.isAnimOsBottom = false;
                            AnimProcessor.this.isOverScrollBottomLocked = false;
                        }
                    });
                }
            });
        }
    }

    public void onScrolled(int distanceY) {
    }

    private void translateExHead(int offsetY) {
        if (!this.cp.isExHeadLocked()) {
            this.cp.getExHead().setTranslationY((float)offsetY);
        }
    }

    public void animLayoutByTime(int start, int end, long time, ValueAnimator.AnimatorUpdateListener listener, Animator.AnimatorListener animatorListener) {
        ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{start, end});
        va.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        va.addUpdateListener(listener);
        va.addListener(animatorListener);
        va.setDuration(time);
        va.start();
    }

    public void animLayoutByTime(int start, int end, long time, ValueAnimator.AnimatorUpdateListener listener) {
        ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{start, end});
        va.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        va.addUpdateListener(listener);
        va.setDuration(time);
        va.start();
    }

    public void animLayoutByTime(int start, int end, ValueAnimator.AnimatorUpdateListener listener, Animator.AnimatorListener animatorListener) {
        ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{start, end});
        va.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        va.addUpdateListener(listener);
        va.addListener(animatorListener);
        va.setDuration((long)((int)((float)Math.abs(start - end) * 1.0f)));
        va.start();
    }
}

