/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.header.progresslayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.vrefresh.IHeaderView;
import com.gymchina.android.vrefresh.OnAnimEndListener;
import com.gymchina.android.vrefresh.header.progresslayout.CircleImageView;
import com.gymchina.android.vrefresh.header.progresslayout.MaterialProgressDrawable;

public class ProgressLayout
extends FrameLayout
implements IHeaderView {
    private int mCircleWidth;
    private int mCircleHeight;
    private static final int CIRCLE_DIAMETER = 40;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private CircleImageView mCircleView;
    private MaterialProgressDrawable mProgress;
    private boolean mIsBeingDragged = false;

    public ProgressLayout(Context context) {
        this(context, null);
    }

    public ProgressLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleWidth = (int)(40.0f * metrics.density);
        this.mCircleHeight = (int)(40.0f * metrics.density);
        this.createProgressView();
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
    }

    private void createProgressView() {
        this.mCircleView = new CircleImageView(this.getContext(), -328966, 20.0f);
        this.mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mProgress.setBackgroundColor(-328966);
        this.mCircleView.setImageDrawable(this.mProgress);
        this.mCircleView.setVisibility(8);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2, 17);
        this.mCircleView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)this.mCircleView);
    }

    public void setProgressBackgroundColorSchemeResource(@ColorRes int colorRes) {
        this.setProgressBackgroundColorSchemeColor(this.getResources().getColor(colorRes));
    }

    public void setProgressBackgroundColorSchemeColor(@ColorInt int color) {
        this.mCircleView.setBackgroundColor(color);
        this.mProgress.setBackgroundColor(color);
    }

    public void setColorSchemeResources(int ... colorResIds) {
        Resources res = this.getResources();
        int[] colorRes = new int[colorResIds.length];
        for (int i = 0; i < colorResIds.length; ++i) {
            colorRes[i] = res.getColor(colorResIds[i]);
        }
        this.setColorSchemeColors(colorRes);
    }

    public void setColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
    }

    public void setSize(int size) {
        if (size != 0 && size != 1) {
            return;
        }
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleHeight = size == 0 ? (this.mCircleWidth = (int)(56.0f * metrics.density)) : (this.mCircleWidth = (int)(40.0f * metrics.density));
        this.mCircleView.setImageDrawable(null);
        this.mProgress.updateSizes(size);
        this.mCircleView.setImageDrawable(this.mProgress);
    }

    @Override
    public void reset() {
        this.mCircleView.clearAnimation();
        this.mProgress.stop();
        this.mCircleView.setVisibility(8);
        this.mCircleView.getBackground().setAlpha(255);
        this.mProgress.setAlpha(255);
        ViewCompat.setScaleX((View)this.mCircleView, (float)0.0f);
        ViewCompat.setScaleY((View)this.mCircleView, (float)0.0f);
        ViewCompat.setAlpha((View)this.mCircleView, (float)1.0f);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void onPullingDown(float fraction, float maxHeadHeight, float headHeight) {
        if (!this.mIsBeingDragged) {
            this.mIsBeingDragged = true;
            this.mProgress.setAlpha(76);
        }
        if (this.mCircleView.getVisibility() != 0) {
            this.mCircleView.setVisibility(0);
        }
        if (fraction >= 1.0f) {
            ViewCompat.setScaleX((View)this.mCircleView, (float)1.0f);
            ViewCompat.setScaleY((View)this.mCircleView, (float)1.0f);
        } else {
            ViewCompat.setScaleX((View)this.mCircleView, (float)fraction);
            ViewCompat.setScaleY((View)this.mCircleView, (float)fraction);
        }
        if (fraction <= 1.0f) {
            this.mProgress.setAlpha((int)(76.0f + 179.0f * fraction));
        }
        float adjustedPercent = (float)Math.max((double)fraction - 0.4, 0.0) * 5.0f / 3.0f;
        float strokeStart = adjustedPercent * 0.8f;
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
        this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
        float rotation = (-0.25f + 0.4f * adjustedPercent) * 0.5f;
        this.mProgress.setProgressRotation(rotation);
    }

    @Override
    public void onPullReleasing(float fraction, float maxHeadHeight, float headHeight) {
        this.mIsBeingDragged = false;
        if (fraction >= 1.0f) {
            ViewCompat.setScaleX((View)this.mCircleView, (float)1.0f);
            ViewCompat.setScaleY((View)this.mCircleView, (float)1.0f);
        } else {
            ViewCompat.setScaleX((View)this.mCircleView, (float)fraction);
            ViewCompat.setScaleY((View)this.mCircleView, (float)fraction);
        }
    }

    @Override
    public void startAnim(float maxHeadHeight, float headHeight) {
        this.mCircleView.setVisibility(0);
        this.mCircleView.getBackground().setAlpha(255);
        this.mProgress.setAlpha(255);
        ViewCompat.setScaleX((View)this.mCircleView, (float)1.0f);
        ViewCompat.setScaleY((View)this.mCircleView, (float)1.0f);
        this.mProgress.setArrowScale(1.0f);
        this.mProgress.start();
    }

    @Override
    public void onFinish(final OnAnimEndListener animEndListener) {
        this.mCircleView.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ProgressLayout.this.reset();
                animEndListener.onAnimEnd();
            }
        }).start();
    }
}

