/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.footer;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.vrefresh.IBottomView;
import com.gymchina.android.vrefresh.utils.DensityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BallPulseView
extends View
implements IBottomView {
    public static final int DEFAULT_SIZE = 50;
    private float circleSpacing;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    private ArrayList<ValueAnimator> mAnimators;
    private Map<ValueAnimator, ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new HashMap<ValueAnimator, ValueAnimator.AnimatorUpdateListener>();
    private Paint mPaint;
    private int normalColor = -1118482;
    private int animatingColor = -1615546;

    public BallPulseView(Context context) {
        this(context, null);
    }

    public BallPulseView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallPulseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int default_size = DensityUtil.dp2px(context, 50.0f);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(default_size, default_size, 17);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.circleSpacing = DensityUtil.dp2px(context, 4.0f);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    public void setIndicatorColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setNormalColor(@ColorInt int color) {
        this.normalColor = color;
    }

    public void setAnimatingColor(@ColorInt int color) {
        this.animatingColor = color;
    }

    protected void onDraw(Canvas canvas) {
        float radius = ((float)Math.min(this.getWidth(), this.getHeight()) - this.circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + this.circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + this.circleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimators != null) {
            for (int i = 0; i < this.mAnimators.size(); ++i) {
                this.mAnimators.get(i).cancel();
            }
        }
    }

    public void startAnim() {
        if (this.mAnimators == null) {
            this.createAnimators();
        }
        if (this.mAnimators == null) {
            return;
        }
        if (this.isStarted()) {
            return;
        }
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            ValueAnimator animator = this.mAnimators.get(i);
            ValueAnimator.AnimatorUpdateListener updateListener = this.mUpdateListeners.get(animator);
            if (updateListener != null) {
                animator.addUpdateListener(updateListener);
            }
            animator.start();
        }
        this.setIndicatorColor(this.animatingColor);
    }

    public void stopAnim() {
        if (this.mAnimators != null) {
            for (ValueAnimator animator : this.mAnimators) {
                if (animator == null || !animator.isStarted()) continue;
                animator.removeAllUpdateListeners();
                animator.end();
            }
        }
        this.setIndicatorColor(this.normalColor);
    }

    private boolean isStarted() {
        Iterator<ValueAnimator> iterator = this.mAnimators.iterator();
        if (iterator.hasNext()) {
            ValueAnimator animator = iterator.next();
            return animator.isStarted();
        }
        return false;
    }

    private void createAnimators() {
        this.mAnimators = new ArrayList();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            scaleAnim.setDuration(750L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            this.mUpdateListeners.put(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallPulseView)BallPulseView.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallPulseView.this.postInvalidate();
                }
            });
            this.mAnimators.add(scaleAnim);
        }
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void onPullingUp(float fraction, float maxHeadHeight, float headHeight) {
        this.stopAnim();
    }

    @Override
    public void startAnim(float maxHeadHeight, float headHeight) {
        this.startAnim();
    }

    @Override
    public void onPullReleasing(float fraction, float maxHeadHeight, float headHeight) {
        this.stopAnim();
    }

    @Override
    public void onFinish() {
        this.stopAnim();
    }

    @Override
    public void reset() {
        this.stopAnim();
    }
}

