/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.recview.decoration;

import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.gymchina.android.recview.adapter.HFRecAdapter;

public class HfItemDecoration
extends RecyclerView.ItemDecoration {
    private final String TAG = "SpaceItemDecoration";
    private int mSpace;
    private boolean mIncludeEdge;
    private boolean mIncludeFirstItemTop;
    private HFRecAdapter mAdapter;

    public HfItemDecoration(int space, boolean includeEdge, HFRecAdapter adapter) {
        this.mSpace = space;
        this.mIncludeEdge = includeEdge;
        this.mAdapter = adapter;
        this.mIncludeFirstItemTop = true;
    }

    public HfItemDecoration(int space, HFRecAdapter adapter, boolean includeFirstItemTop) {
        this.mSpace = space;
        this.mIncludeEdge = false;
        this.mIncludeFirstItemTop = includeFirstItemTop;
        this.mAdapter = adapter;
    }

    public void setHFAdapter(HFRecAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.mAdapter == null) {
            super.getItemOffsets(outRect, view, parent, state);
            return;
        }
        int position = this.mAdapter.getRealPosition(parent.getChildAdapterPosition(view));
        if (position < 0) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            outRect = this.getStagRect((StaggeredGridLayoutManager)layoutManager, outRect, view, position, this.mIncludeEdge, this.mSpace);
        } else if (layoutManager instanceof GridLayoutManager) {
            outRect = this.getGridRect((GridLayoutManager)layoutManager, outRect, view, position, this.mIncludeEdge, this.mSpace);
        } else if (layoutManager instanceof LinearLayoutManager) {
            outRect = this.getLineRect((LinearLayoutManager)layoutManager, outRect, position, this.mIncludeEdge, this.mSpace);
        }
    }

    private Rect getLineRect(LinearLayoutManager layoutManager, Rect outRect, int position, boolean includeEdge, int space) {
        if (layoutManager.canScrollVertically()) {
            if (includeEdge) {
                outRect.left = space;
                outRect.right = space;
            }
            outRect.bottom = space;
            outRect.top = this.mIncludeFirstItemTop && position == 0 ? space : 0;
        } else if (layoutManager.canScrollHorizontally()) {
            if (includeEdge) {
                outRect.bottom = space;
                outRect.top = space;
            }
            outRect.right = space;
            outRect.left = this.mIncludeFirstItemTop && position == 0 ? space : 0;
        }
        return outRect;
    }

    private Rect getStagRect(StaggeredGridLayoutManager layoutManager, Rect outRect, View view, int position, boolean includeEdge, int space) {
        if (view.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            if (layoutManager.canScrollVertically()) {
                int column = ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
                int spanCount = layoutManager.getSpanCount();
                if (includeEdge) {
                    outRect.left = space - column * space / spanCount;
                    outRect.right = (column + 1) * space / spanCount;
                    if (position < spanCount) {
                        outRect.top = space;
                    }
                    outRect.bottom = space;
                } else {
                    outRect.left = column * space / spanCount;
                    outRect.right = space - (column + 1) * space / spanCount;
                    if (position >= spanCount) {
                        outRect.top = space;
                    }
                }
            } else if (layoutManager.canScrollHorizontally()) {
                int row = ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
                int spanCount = layoutManager.getSpanCount();
                if (includeEdge) {
                    outRect.top = space - row * space / spanCount;
                    outRect.bottom = (row + 1) * space / spanCount;
                    if (position < spanCount) {
                        outRect.left = space;
                    }
                    outRect.right = space;
                } else {
                    outRect.top = row * space / spanCount;
                    outRect.bottom = space - (row + 1) * space / spanCount;
                    if (position >= spanCount) {
                        outRect.left = space;
                    }
                }
            }
        }
        return outRect;
    }

    private Rect getGridRect(GridLayoutManager layoutManager, Rect outRect, View view, int position, boolean includeEdge, int space) {
        if (view.getLayoutParams() instanceof GridLayoutManager.LayoutParams) {
            if (layoutManager.canScrollVertically()) {
                int column = ((GridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
                int spanCount = layoutManager.getSpanCount();
                if (includeEdge) {
                    outRect.left = space - column * space / spanCount;
                    outRect.right = (column + 1) * space / spanCount;
                    if (position < spanCount) {
                        outRect.top = space;
                    }
                    outRect.bottom = space;
                } else {
                    outRect.left = column * space / spanCount;
                    outRect.right = space - (column + 1) * space / spanCount;
                    if (position >= spanCount) {
                        outRect.top = space;
                    }
                }
            } else if (layoutManager.canScrollHorizontally()) {
                int row = ((GridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
                int spanCount = layoutManager.getSpanCount();
                if (includeEdge) {
                    outRect.top = space - row * space / spanCount;
                    outRect.bottom = (row + 1) * space / spanCount;
                    if (position < spanCount) {
                        outRect.left = space;
                    }
                    outRect.right = space;
                } else {
                    outRect.top = row * space / spanCount;
                    outRect.bottom = space - (row + 1) * space / spanCount;
                    if (position >= spanCount) {
                        outRect.left = space;
                    }
                }
            }
        }
        return outRect;
    }
}

