/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.recview.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.gymchina.android.recview.holder.AbsViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsRecAdapter<T>
extends RecyclerView.Adapter {
    protected Context mContext;
    protected T mSelectItem;
    protected List<T> mList;

    public AbsRecAdapter(Context context) {
        this.mContext = context;
        this.mList = new ArrayList<T>();
    }

    protected abstract View inflateView(ViewGroup var1, int var2);

    protected abstract AbsViewHolder getViewHolder(View var1, int var2);

    protected abstract void bindVHolder(AbsViewHolder var1, int var2);

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflateView(parent, viewType);
        return this.getViewHolder(view, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.bindVHolder((AbsViewHolder)holder, position);
    }

    public int getItemCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public void setList(List<T> list) {
        this.clean();
        this.addAll(list);
    }

    public List<T> getList() {
        return this.mList;
    }

    public void add(T t) {
        if (t == null) {
            return;
        }
        this.mList.add(t);
    }

    public void add(int location, T t) {
        if (t == null) {
            return;
        }
        this.mList.add(location, t);
    }

    public void addAll(List<? extends T> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.mList.addAll(list);
    }

    public void addAll(int location, List<? extends T> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (location >= 0) {
            this.mList.addAll(location, list);
        }
    }

    public void remove(int index) {
        if (this.mList == null || this.mList.isEmpty()) {
            return;
        }
        if (index >= this.mList.size()) {
            return;
        }
        this.mList.remove(index);
    }

    public void remove(T t) {
        if (this.mList == null || this.mList.isEmpty()) {
            return;
        }
        this.mList.remove(t);
    }

    public T getItem(int pos) {
        if (pos < 0) {
            return null;
        }
        if (this.mList == null || this.mList.isEmpty()) {
            return null;
        }
        if (pos >= this.mList.size()) {
            return null;
        }
        return this.mList.get(pos);
    }

    public void clean() {
        if (this.mList == null || this.mList.isEmpty()) {
            return;
        }
        this.mList.clear();
    }

    public T getSelectItem() {
        return this.mSelectItem;
    }

    public void setSelectItem(T selectItem) {
        this.mSelectItem = selectItem;
    }
}

