/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.utils;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ScrollingUtil {
    private ScrollingUtil() {
    }

    public static boolean canChildScrollUp(View mChildView) {
        if (mChildView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)mChildView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)mChildView, (int)-1) || mChildView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)mChildView, (int)-1);
    }

    public static boolean canChildScrollDown(View mChildView) {
        if (Build.VERSION.SDK_INT < 14) {
            if (mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)mChildView;
                return absListView.getChildCount() > 0 && (absListView.getLastVisiblePosition() < absListView.getChildCount() - 1 || absListView.getChildAt(absListView.getChildCount() - 1).getBottom() > absListView.getPaddingBottom());
            }
            return ViewCompat.canScrollVertically((View)mChildView, (int)1) || mChildView.getScrollY() < 0;
        }
        return ViewCompat.canScrollVertically((View)mChildView, (int)1);
    }

    public static boolean isScrollViewOrWebViewToTop(View view) {
        return view != null && view.getScrollY() == 0;
    }

    public static boolean isViewToTop(View view, int mTouchSlop) {
        if (view instanceof AbsListView) {
            return ScrollingUtil.isAbsListViewToTop((AbsListView)view);
        }
        if (view instanceof RecyclerView) {
            return ScrollingUtil.isRecyclerViewToTop((RecyclerView)view);
        }
        return view != null && Math.abs(view.getScrollY()) <= 2 * mTouchSlop;
    }

    public static boolean isViewToBottom(View view, int mTouchSlop) {
        if (view instanceof AbsListView) {
            return ScrollingUtil.isAbsListViewToBottom((AbsListView)view);
        }
        if (view instanceof RecyclerView) {
            return ScrollingUtil.isRecyclerViewToBottom((RecyclerView)view);
        }
        if (view instanceof WebView) {
            return ScrollingUtil.isWebViewToBottom((WebView)view, mTouchSlop);
        }
        if (view instanceof ViewGroup) {
            return ScrollingUtil.isViewGroupToBottom((ViewGroup)view);
        }
        return false;
    }

    public static boolean isAbsListViewToTop(AbsListView absListView) {
        if (absListView != null) {
            int firstChildTop = 0;
            if (absListView.getChildCount() > 0) {
                firstChildTop = absListView.getChildAt(0).getTop() - absListView.getPaddingTop();
            }
            return absListView.getFirstVisiblePosition() == 0 && firstChildTop == 0;
        }
        return false;
    }

    public static boolean isRecyclerViewToTop(RecyclerView recyclerView) {
        if (recyclerView != null) {
            RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
            if (manager == null) {
                return true;
            }
            if (manager.getItemCount() == 0) {
                return true;
            }
            if (manager instanceof LinearLayoutManager) {
                LinearLayoutManager layoutManager = (LinearLayoutManager)manager;
                int firstChildTop = 0;
                if (recyclerView.getChildCount() > 0) {
                    View firstVisibleChild = recyclerView.getChildAt(0);
                    if (firstVisibleChild != null && firstVisibleChild.getMeasuredHeight() >= recyclerView.getMeasuredHeight()) {
                        if (Build.VERSION.SDK_INT < 14) {
                            return !ViewCompat.canScrollVertically((View)recyclerView, (int)-1) && recyclerView.getScrollY() <= 0;
                        }
                        return !ViewCompat.canScrollVertically((View)recyclerView, (int)-1);
                    }
                    View firstChild = recyclerView.getChildAt(0);
                    RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)firstChild.getLayoutParams();
                    firstChildTop = firstChild.getTop() - layoutParams.topMargin - ScrollingUtil.getRecyclerViewItemTopInset(layoutParams) - recyclerView.getPaddingTop();
                }
                return layoutManager.findFirstCompletelyVisibleItemPosition() < 1 && firstChildTop == 0;
            }
            if (manager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager layoutManager = (StaggeredGridLayoutManager)manager;
                int[] out = layoutManager.findFirstCompletelyVisibleItemPositions(null);
                return out[0] < 1;
            }
        }
        return false;
    }

    private static int getRecyclerViewItemTopInset(RecyclerView.LayoutParams layoutParams) {
        try {
            Field field = RecyclerView.LayoutParams.class.getDeclaredField("mDecorInsets");
            field.setAccessible(true);
            Rect decorInsets = (Rect)field.get(layoutParams);
            return decorInsets.top;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isWebViewToBottom(WebView webview, int mTouchSlop) {
        return webview != null && (float)webview.getContentHeight() * webview.getScale() - (float)(webview.getHeight() + webview.getScrollY()) <= (float)(2 * mTouchSlop);
    }

    public static boolean isViewGroupToBottom(ViewGroup viewGroup) {
        View subChildView = viewGroup.getChildAt(0);
        return subChildView != null && subChildView.getMeasuredHeight() <= viewGroup.getScrollY() + viewGroup.getHeight();
    }

    public static boolean isScrollViewToBottom(ScrollView scrollView) {
        if (scrollView != null) {
            int realContentHeight;
            int scrollContentHeight = scrollView.getScrollY() + scrollView.getMeasuredHeight() - scrollView.getPaddingTop() - scrollView.getPaddingBottom();
            return scrollContentHeight == (realContentHeight = scrollView.getChildAt(0).getMeasuredHeight());
        }
        return false;
    }

    public static boolean isAbsListViewToBottom(AbsListView absListView) {
        if (absListView != null && absListView.getAdapter() != null && absListView.getChildCount() > 0 && absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1) {
            View lastChild = absListView.getChildAt(absListView.getChildCount() - 1);
            return lastChild.getBottom() <= absListView.getMeasuredHeight();
        }
        return false;
    }

    public static boolean isRecyclerViewToBottom(RecyclerView recyclerView) {
        if (recyclerView != null) {
            RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
            if (manager == null || manager.getItemCount() == 0) {
                return false;
            }
            if (manager instanceof LinearLayoutManager) {
                View lastVisibleChild = recyclerView.getChildAt(recyclerView.getChildCount() - 1);
                if (lastVisibleChild != null && lastVisibleChild.getMeasuredHeight() >= recyclerView.getMeasuredHeight()) {
                    if (Build.VERSION.SDK_INT < 14) {
                        return !ViewCompat.canScrollVertically((View)recyclerView, (int)1) && recyclerView.getScrollY() >= 0;
                    }
                    return !ViewCompat.canScrollVertically((View)recyclerView, (int)1);
                }
                LinearLayoutManager layoutManager = (LinearLayoutManager)manager;
                return layoutManager.findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1;
            }
            if (manager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager layoutManager = (StaggeredGridLayoutManager)manager;
                int[] out = layoutManager.findLastCompletelyVisibleItemPositions(null);
                int lastPosition = layoutManager.getItemCount() - 1;
                for (int position : out) {
                    if (position != lastPosition) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void scrollAViewBy(View view, int height) {
        if (view instanceof RecyclerView) {
            view.scrollBy(0, height);
        } else if (view instanceof ScrollView) {
            ((ScrollView)view).smoothScrollBy(0, height);
        } else if (view instanceof AbsListView) {
            ((AbsListView)view).smoothScrollBy(height, 0);
        } else {
            try {
                Method method = view.getClass().getDeclaredMethod("smoothScrollBy", Integer.class, Integer.class);
                method.invoke((Object)view, 0, height);
            }
            catch (Exception e) {
                view.scrollBy(0, height);
            }
        }
    }

    public static void scrollToBottom(final ScrollView scrollView) {
        if (scrollView != null) {
            scrollView.post(new Runnable(){

                @Override
                public void run() {
                    scrollView.fullScroll(130);
                }
            });
        }
    }

    public static void scrollToBottom(final AbsListView absListView) {
        if (absListView != null && absListView.getAdapter() != null && ((ListAdapter)absListView.getAdapter()).getCount() > 0) {
            absListView.post(new Runnable(){

                @Override
                public void run() {
                    absListView.setSelection(((ListAdapter)absListView.getAdapter()).getCount() - 1);
                }
            });
        }
    }

    public static void scrollToBottom(final RecyclerView recyclerView) {
        if (recyclerView != null && recyclerView.getAdapter() != null && recyclerView.getAdapter().getItemCount() > 0) {
            recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    recyclerView.smoothScrollToPosition(recyclerView.getAdapter().getItemCount() - 1);
                }
            });
        }
    }

    public static void scrollToBottom(View view) {
        if (view instanceof RecyclerView) {
            ScrollingUtil.scrollToBottom((RecyclerView)view);
        }
        if (view instanceof AbsListView) {
            ScrollingUtil.scrollToBottom((AbsListView)view);
        }
        if (view instanceof ScrollView) {
            ScrollingUtil.scrollToBottom((ScrollView)view);
        }
    }

    public static int getScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }
}

