/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.processor;

import android.view.MotionEvent;
import com.gymchina.android.vrefresh.VerticalRefreshLayout;
import com.gymchina.android.vrefresh.processor.IDecorator;
import com.gymchina.android.vrefresh.utils.ScrollingUtil;

public class RefreshProcessor
implements IDecorator {
    protected VerticalRefreshLayout.CoContext cp;
    private float mTouchX;
    private float mTouchY;

    public RefreshProcessor(VerticalRefreshLayout.CoContext processor) {
        if (processor == null) {
            throw new NullPointerException("The coprocessor can not be null.");
        }
        this.cp = processor;
    }

    @Override
    public boolean interceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mTouchX = ev.getX();
                this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float dx = ev.getX() - this.mTouchX;
                float dy = ev.getY() - this.mTouchY;
                if (!(Math.abs(dx) <= Math.abs(dy))) break;
                if (dy > 0.0f && ScrollingUtil.isViewToTop(this.cp.getTargetView(), this.cp.getTouchSlop()) && this.cp.allowPullDown()) {
                    this.cp.setStatePTD();
                    return true;
                }
                if (!(dy < 0.0f) || !ScrollingUtil.isViewToBottom(this.cp.getTargetView(), this.cp.getTouchSlop()) || !this.cp.allowPullUp()) break;
                this.cp.setStatePBU();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dealTouchEvent(MotionEvent e) {
        if (this.cp.isRefreshVisible() || this.cp.isLoadingVisible()) {
            return false;
        }
        switch (e.getAction()) {
            case 2: {
                float dy = e.getY() - this.mTouchY;
                if (this.cp.isStatePTD()) {
                    dy = Math.min(this.cp.getMaxHeadHeight() * 2.0f, dy);
                    dy = Math.max(0.0f, dy);
                    this.cp.getAnimProcessor().scrollHeadByMove(dy);
                } else if (this.cp.isStatePBU()) {
                    dy = Math.min((float)(this.cp.getMaxBottomHeight() * 2), Math.abs(dy));
                    dy = Math.max(0.0f, dy);
                    this.cp.getAnimProcessor().scrollBottomByMove(dy);
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.cp.isStatePTD()) {
                    this.cp.getAnimProcessor().dealPullDownRelease();
                } else if (this.cp.isStatePBU()) {
                    this.cp.getAnimProcessor().dealPullUpRelease();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onFingerDown(MotionEvent ev) {
    }

    @Override
    public void onFingerScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY, float velocityY) {
        int mTouchSlop = this.cp.getTouchSlop();
        if (this.cp.isRefreshVisible() && distanceY >= (float)mTouchSlop && !this.cp.isOpenFloatRefresh()) {
            this.cp.setRefreshing(false);
            this.cp.getAnimProcessor().animHeadHideByVy((int)velocityY);
        }
        if (this.cp.isLoadingVisible() && distanceY <= (float)(-mTouchSlop)) {
            this.cp.setLoadingMore(false);
            this.cp.getAnimProcessor().animBottomHideByVy((int)velocityY);
        }
    }

    @Override
    public void onFingerFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
    }
}

