/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh.header;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.gymchina.android.vrefresh.IHeaderView;
import com.gymchina.android.vrefresh.OnAnimEndListener;
import com.gymchina.android.vrefresh.utils.DensityUtil;

public class GoogleDotView
extends View
implements IHeaderView {
    private Paint mPath;
    private float r;
    private int num = 5;
    private int cir_x;
    float fraction1;
    float fraction2;
    boolean animating = false;
    ValueAnimator animator1;
    ValueAnimator animator2;

    public void setCir_x(int cir_x) {
        this.cir_x = cir_x;
    }

    public GoogleDotView(Context context) {
        this(context, null, 0);
    }

    public GoogleDotView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GoogleDotView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.r = DensityUtil.dp2px(this.getContext(), 4.0f);
        this.mPath = new Paint();
        this.mPath.setAntiAlias(true);
        this.mPath.setColor(Color.rgb((int)114, (int)114, (int)114));
        this.animator1 = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.2f, 1.0f, 0.8f});
        this.animator1.setDuration(800L);
        this.animator1.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                GoogleDotView.this.fraction1 = ((Float)animation.getAnimatedValue()).floatValue();
                GoogleDotView.this.invalidate();
            }
        });
        this.animator1.setRepeatCount(-1);
        this.animator1.setRepeatMode(2);
        this.animator2 = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f, 1.2f});
        this.animator2.setDuration(800L);
        this.animator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                GoogleDotView.this.fraction2 = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        this.animator2.setRepeatCount(-1);
        this.animator2.setRepeatMode(2);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getMeasuredWidth() / this.num - 10;
        block14: for (int i = 0; i < this.num; ++i) {
            if (this.animating) {
                switch (i) {
                    case 0: {
                        this.mPath.setAlpha(105);
                        this.mPath.setColor(-256);
                        canvas.drawCircle((float)(this.getMeasuredWidth() / 2 - this.cir_x * 2 - 2 * w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r * this.fraction2, this.mPath);
                        break;
                    }
                    case 1: {
                        this.mPath.setAlpha(145);
                        this.mPath.setColor(-16711936);
                        canvas.drawCircle((float)(this.getMeasuredWidth() / 2 - this.cir_x * 1 - w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r * this.fraction2, this.mPath);
                        break;
                    }
                    case 2: {
                        this.mPath.setAlpha(255);
                        this.mPath.setColor(-16776961);
                        canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), this.r * this.fraction1, this.mPath);
                        break;
                    }
                    case 3: {
                        this.mPath.setAlpha(145);
                        this.mPath.setColor(-65536);
                        canvas.drawCircle((float)(this.getMeasuredWidth() / 2 + this.cir_x * 1 + w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r * this.fraction2, this.mPath);
                        break;
                    }
                    case 4: {
                        this.mPath.setAlpha(105);
                        this.mPath.setColor(-256);
                        canvas.drawCircle((float)(this.getMeasuredWidth() / 2 + this.cir_x * 2 + 2 * w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r * this.fraction2, this.mPath);
                    }
                }
                continue;
            }
            switch (i) {
                case 0: {
                    this.mPath.setAlpha(105);
                    this.mPath.setColor(-256);
                    canvas.drawCircle((float)(this.getMeasuredWidth() / 2 - this.cir_x * 2 - 2 * w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r, this.mPath);
                    continue block14;
                }
                case 1: {
                    this.mPath.setAlpha(145);
                    this.mPath.setColor(-16711936);
                    canvas.drawCircle((float)(this.getMeasuredWidth() / 2 - this.cir_x * 1 - w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r, this.mPath);
                    continue block14;
                }
                case 2: {
                    this.mPath.setAlpha(255);
                    this.mPath.setColor(-16776961);
                    canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), this.r, this.mPath);
                    continue block14;
                }
                case 3: {
                    this.mPath.setAlpha(145);
                    this.mPath.setColor(-65536);
                    canvas.drawCircle((float)(this.getMeasuredWidth() / 2 + this.cir_x * 1 + w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r, this.mPath);
                    continue block14;
                }
                case 4: {
                    this.mPath.setAlpha(105);
                    this.mPath.setColor(-256);
                    canvas.drawCircle((float)(this.getMeasuredWidth() / 2 + this.cir_x * 2 + 2 * w / 3 * 2), (float)(this.getMeasuredHeight() / 2), this.r, this.mPath);
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.animator1 != null) {
            this.animator1.cancel();
        }
        if (this.animator2 != null) {
            this.animator2.cancel();
        }
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void onPullingDown(float fraction, float maxHeadHeight, float headHeight) {
        this.setScaleX(1.0f + fraction / 2.0f);
        this.setScaleY(1.0f + fraction / 2.0f);
        this.animating = false;
        if (this.animator1.isRunning()) {
            this.animator1.cancel();
            this.invalidate();
        }
        if (this.animator2.isRunning()) {
            this.animator2.cancel();
        }
    }

    @Override
    public void onPullReleasing(float fraction, float maxHeadHeight, float headHeight) {
        this.setScaleX(1.0f + fraction / 2.0f);
        this.setScaleY(1.0f + fraction / 2.0f);
        if (fraction < 1.0f) {
            this.animating = false;
            if (this.animator1.isRunning()) {
                this.animator1.cancel();
                this.invalidate();
            }
            if (this.animator2.isRunning()) {
                this.animator2.cancel();
            }
        }
    }

    @Override
    public void startAnim(float maxHeadHeight, float headHeight) {
        this.animating = true;
        this.animator1.start();
        this.animator2.start();
    }

    @Override
    public void onFinish(OnAnimEndListener listener) {
        listener.onAnimEnd();
    }

    @Override
    public void reset() {
        this.animating = false;
        if (this.animator1.isRunning()) {
            this.animator1.cancel();
        }
        if (this.animator2.isRunning()) {
            this.animator2.cancel();
        }
        this.invalidate();
    }
}

