/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.vrefresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.gymchina.android.recview.R;
import com.gymchina.android.vrefresh.IBottomView;
import com.gymchina.android.vrefresh.IHeaderView;
import com.gymchina.android.vrefresh.OnAnimEndListener;
import com.gymchina.android.vrefresh.PullListener;
import com.gymchina.android.vrefresh.RefreshListenerAdapter;
import com.gymchina.android.vrefresh.footer.BallPulseView;
import com.gymchina.android.vrefresh.header.GoogleDotView;
import com.gymchina.android.vrefresh.processor.AnimProcessor;
import com.gymchina.android.vrefresh.processor.IDecorator;
import com.gymchina.android.vrefresh.processor.OverScrollDecorator;
import com.gymchina.android.vrefresh.processor.RefreshProcessor;
import com.gymchina.android.vrefresh.utils.DensityUtil;

public class VerticalRefreshLayout
extends RelativeLayout
implements PullListener {
    protected float mMaxHeadHeight;
    protected float mMaxBottomHeight;
    protected float mHeadHeight;
    protected float mOverScrollHeight;
    private View mChildView;
    protected FrameLayout mHeadLayout;
    private FrameLayout mExtraHeadLayout;
    private int mExHeadHeight = 0;
    private IHeaderView mHeadView;
    private IBottomView mBottomView;
    private float mBottomHeight;
    private FrameLayout mBottomLayout;
    protected boolean isRefreshVisible = false;
    protected boolean isLoadingVisible = false;
    protected boolean enableLoadmore = true;
    protected boolean enableRefresh = true;
    protected boolean isOverScrollTopShow = true;
    protected boolean isOverScrollBottomShow = true;
    protected boolean isPureScrollModeOn = false;
    protected boolean autoLoadMore = false;
    protected boolean floatRefresh = false;
    protected boolean enableOverScroll = true;
    private CoContext cp;
    private int mTouchSlop;
    private IDecorator decorator;
    private GestureDetector gestureDetector;
    private VelocityTracker moveTracker;
    private int mPointerId;
    private float vy;
    int mMaxVelocity = ViewConfiguration.get((Context)this.getContext()).getScaledMaximumFlingVelocity();
    private RefreshListenerAdapter refreshListener;
    private PullListener pullListener;

    public VerticalRefreshLayout(Context context) {
        this(context, null, 0);
    }

    public VerticalRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerticalRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VerticalRefreshLayout, defStyleAttr, 0);
        try {
            this.mMaxHeadHeight = a.getDimensionPixelSize(R.styleable.VerticalRefreshLayout_tr_max_head_height, DensityUtil.dp2px(context, 120.0f));
            this.mHeadHeight = a.getDimensionPixelSize(R.styleable.VerticalRefreshLayout_tr_head_height, DensityUtil.dp2px(context, 80.0f));
            this.mMaxBottomHeight = a.getDimensionPixelSize(R.styleable.VerticalRefreshLayout_tr_max_bottom_height, DensityUtil.dp2px(context, 120.0f));
            this.mBottomHeight = a.getDimensionPixelSize(R.styleable.VerticalRefreshLayout_tr_bottom_height, DensityUtil.dp2px(context, 60.0f));
            this.mOverScrollHeight = a.getDimensionPixelSize(R.styleable.VerticalRefreshLayout_tr_overscroll_height, (int)this.mHeadHeight);
            this.enableLoadmore = a.getBoolean(R.styleable.VerticalRefreshLayout_tr_enable_loadmore, true);
            this.isPureScrollModeOn = a.getBoolean(R.styleable.VerticalRefreshLayout_tr_pureScrollMode_on, false);
            this.isOverScrollTopShow = a.getBoolean(R.styleable.VerticalRefreshLayout_tr_overscroll_top_show, true);
            this.isOverScrollBottomShow = a.getBoolean(R.styleable.VerticalRefreshLayout_tr_overscroll_bottom_show, true);
            this.enableOverScroll = a.getBoolean(R.styleable.VerticalRefreshLayout_tr_enable_overscroll, true);
        }
        finally {
            a.recycle();
        }
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.cp = new CoContext();
        this.addHeader();
        this.addFooter();
        this.setPullListener(this);
    }

    private void addHeader() {
        FrameLayout headViewLayout = new FrameLayout(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, 0);
        layoutParams.addRule(10);
        FrameLayout extraHeadLayout = new FrameLayout(this.getContext());
        extraHeadLayout.setId(R.id.ex_header);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
        this.addView((View)extraHeadLayout, (ViewGroup.LayoutParams)layoutParams2);
        this.addView((View)headViewLayout, (ViewGroup.LayoutParams)layoutParams);
        this.mExtraHeadLayout = extraHeadLayout;
        this.mHeadLayout = headViewLayout;
        if (this.mHeadView == null) {
            this.setHeaderView(new GoogleDotView(this.getContext()));
        }
    }

    private void addFooter() {
        FrameLayout bottomViewLayout = new FrameLayout(this.getContext());
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, 0);
        layoutParams2.addRule(12);
        bottomViewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.mBottomLayout = bottomViewLayout;
        this.addView((View)this.mBottomLayout);
        if (this.mBottomView == null) {
            BallPulseView ballPulseView = new BallPulseView(this.getContext());
            this.setBottomView(ballPulseView);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mChildView = this.getChildAt(3);
        this.cp.init();
        this.decorator = new OverScrollDecorator(this.cp, new RefreshProcessor(this.cp));
        this.initGestureDetector();
    }

    private void initGestureDetector() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent ev) {
                VerticalRefreshLayout.this.decorator.onFingerDown(ev);
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                VerticalRefreshLayout.this.decorator.onFingerScroll(e1, e2, distanceX, distanceY, VerticalRefreshLayout.this.vy);
                return false;
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                VerticalRefreshLayout.this.decorator.onFingerFling(e1, e2, velocityX, velocityY);
                return false;
            }
        });
    }

    private void obtainTracker(MotionEvent event) {
        if (null == this.moveTracker) {
            this.moveTracker = VelocityTracker.obtain();
        }
        this.moveTracker.addMovement(event);
    }

    private void releaseTracker() {
        if (null != this.moveTracker) {
            this.moveTracker.clear();
            this.moveTracker.recycle();
            this.moveTracker = null;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.obtainTracker(event);
        switch (event.getAction()) {
            case 0: {
                this.mPointerId = event.getPointerId(0);
                break;
            }
            case 1: 
            case 3: {
                this.moveTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                this.vy = this.moveTracker.getYVelocity(this.mPointerId);
                this.releaseTracker();
            }
        }
        this.gestureDetector.onTouchEvent(event);
        return super.dispatchTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercept = this.decorator.interceptTouchEvent(ev);
        return intercept || super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent e) {
        boolean consume = this.decorator.dealTouchEvent(e);
        return consume || super.onTouchEvent(e);
    }

    public void startRefresh() {
        this.cp.startRefresh();
    }

    public void startLoadMore() {
        this.cp.startLoadMore();
    }

    public void finishRefreshing() {
        this.cp.finishRefreshing();
    }

    public void finishLoadmore() {
        this.cp.finishLoadmore();
    }

    public void setTargetView(View targetView) {
        if (targetView != null) {
            this.mChildView = targetView;
        }
    }

    public void setDecorator(IDecorator decorator1) {
        if (decorator1 != null) {
            this.decorator = decorator1;
        }
    }

    public void setHeaderView(final IHeaderView headerView) {
        if (headerView != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    VerticalRefreshLayout.this.mHeadLayout.removeAllViewsInLayout();
                    VerticalRefreshLayout.this.mHeadLayout.addView(headerView.getView());
                }
            });
            this.mHeadView = headerView;
        }
    }

    public void addFixedExHeader(final View view) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (view != null && VerticalRefreshLayout.this.mExtraHeadLayout != null) {
                    VerticalRefreshLayout.this.mExtraHeadLayout.addView(view);
                    VerticalRefreshLayout.this.mExtraHeadLayout.bringToFront();
                    VerticalRefreshLayout.this.cp.onAddExHead();
                    VerticalRefreshLayout.this.cp.setExHeadFixed();
                }
            }
        });
    }

    public View getExtraHeaderView() {
        return this.mExtraHeadLayout;
    }

    public void setBottomView(final IBottomView bottomView) {
        if (bottomView != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    VerticalRefreshLayout.this.mBottomLayout.removeAllViewsInLayout();
                    VerticalRefreshLayout.this.mBottomLayout.addView(bottomView.getView());
                }
            });
            this.mBottomView = bottomView;
        }
    }

    public void setFloatRefresh(boolean ifOpenFloatRefreshMode) {
        this.floatRefresh = ifOpenFloatRefreshMode;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (VerticalRefreshLayout.this.mHeadLayout != null) {
                    VerticalRefreshLayout.this.mHeadLayout.bringToFront();
                }
            }
        });
    }

    public void setMaxHeadHeight(float maxHeightDp) {
        this.mMaxHeadHeight = DensityUtil.dp2px(this.getContext(), maxHeightDp);
    }

    public void setHeaderHeight(float headHeightDp) {
        this.mHeadHeight = DensityUtil.dp2px(this.getContext(), headHeightDp);
    }

    public void setMaxBottomHeight(float maxBottomHeight) {
        this.mMaxBottomHeight = DensityUtil.dp2px(this.getContext(), maxBottomHeight);
    }

    public void setBottomHeight(float bottomHeightDp) {
        this.mBottomHeight = DensityUtil.dp2px(this.getContext(), bottomHeightDp);
    }

    public void setEnableLoadmore(boolean enableLoadmore1) {
        this.enableLoadmore = enableLoadmore1;
        if (this.mBottomView != null) {
            if (this.enableLoadmore) {
                this.mBottomView.getView().setVisibility(0);
            } else {
                this.mBottomView.getView().setVisibility(8);
            }
        }
    }

    public void setEnableRefresh(boolean enableRefresh1) {
        this.enableRefresh = enableRefresh1;
        if (this.mHeadView != null) {
            if (this.enableRefresh) {
                this.mHeadView.getView().setVisibility(0);
            } else {
                this.mHeadView.getView().setVisibility(8);
            }
        }
    }

    public void setOverScrollTopShow(boolean isOverScrollTopShow) {
        this.isOverScrollTopShow = isOverScrollTopShow;
    }

    public void setOverScrollBottomShow(boolean isOverScrollBottomShow) {
        this.isOverScrollBottomShow = isOverScrollBottomShow;
    }

    public void setOverScrollRefreshShow(boolean isOverScrollRefreshShow) {
        this.isOverScrollTopShow = isOverScrollRefreshShow;
        this.isOverScrollBottomShow = isOverScrollRefreshShow;
    }

    public void setEnableOverScroll(boolean enableOverScroll1) {
        this.enableOverScroll = enableOverScroll1;
    }

    public void setPureScrollModeOn(boolean pureScrollModeOn) {
        this.isPureScrollModeOn = pureScrollModeOn;
        if (pureScrollModeOn) {
            this.isOverScrollTopShow = false;
            this.isOverScrollBottomShow = false;
            this.setMaxHeadHeight(this.mOverScrollHeight);
            this.setHeaderHeight(this.mOverScrollHeight);
            this.setMaxBottomHeight(this.mOverScrollHeight);
            this.setBottomHeight(this.mOverScrollHeight);
        }
    }

    public void setOverScrollHeight(float overScrollHeightDp) {
        this.mOverScrollHeight = DensityUtil.dp2px(this.getContext(), overScrollHeightDp);
    }

    public void setAutoLoadMore(boolean ifAutoLoadMore) {
        this.autoLoadMore = ifAutoLoadMore;
        this.setEnableLoadmore(true);
    }

    public void setOnRefreshListener(RefreshListenerAdapter refreshListener) {
        if (refreshListener != null) {
            this.refreshListener = refreshListener;
        }
    }

    private void setPullListener(PullListener pullListener) {
        this.pullListener = pullListener;
    }

    @Override
    public void onPullingDown(VerticalRefreshLayout refreshLayout, float fraction) {
        this.mHeadView.onPullingDown(fraction, this.mMaxHeadHeight, this.mHeadHeight);
        if (!this.enableRefresh) {
            return;
        }
        if (this.refreshListener != null) {
            this.refreshListener.onPullingDown(refreshLayout, fraction);
        }
    }

    @Override
    public void onPullingUp(VerticalRefreshLayout refreshLayout, float fraction) {
        this.mBottomView.onPullingUp(fraction, this.mMaxHeadHeight, this.mHeadHeight);
        if (!this.enableLoadmore) {
            return;
        }
        if (this.refreshListener != null) {
            this.refreshListener.onPullingUp(refreshLayout, fraction);
        }
    }

    @Override
    public void onPullDownReleasing(VerticalRefreshLayout refreshLayout, float fraction) {
        this.mHeadView.onPullReleasing(fraction, this.mMaxHeadHeight, this.mHeadHeight);
        if (!this.enableRefresh) {
            return;
        }
        if (this.refreshListener != null) {
            this.refreshListener.onPullDownReleasing(refreshLayout, fraction);
        }
    }

    @Override
    public void onPullUpReleasing(VerticalRefreshLayout refreshLayout, float fraction) {
        this.mBottomView.onPullReleasing(fraction, this.mMaxBottomHeight, this.mBottomHeight);
        if (!this.enableLoadmore) {
            return;
        }
        if (this.refreshListener != null) {
            this.refreshListener.onPullUpReleasing(refreshLayout, fraction);
        }
    }

    @Override
    public void onRefresh(VerticalRefreshLayout refreshLayout) {
        this.mHeadView.startAnim(this.mMaxHeadHeight, this.mHeadHeight);
        if (this.refreshListener != null) {
            this.refreshListener.onRefresh(refreshLayout);
        }
    }

    @Override
    public void onLoadMore(VerticalRefreshLayout refreshLayout) {
        this.mBottomView.startAnim(this.mMaxBottomHeight, this.mBottomHeight);
        if (this.refreshListener != null) {
            this.refreshListener.onLoadMore(refreshLayout);
        }
    }

    @Override
    public void onFinishRefresh() {
        if (!this.isRefreshVisible) {
            return;
        }
        this.mHeadView.onFinish(new OnAnimEndListener(){

            @Override
            public void onAnimEnd() {
                VerticalRefreshLayout.this.cp.finishRefreshAfterAnim();
            }
        });
    }

    @Override
    public void onFinishLoadMore() {
        if (!this.isLoadingVisible) {
            return;
        }
        this.mBottomView.onFinish();
    }

    @Override
    public void onRefreshCanceled() {
        if (this.refreshListener != null) {
            this.refreshListener.onRefreshCanceled();
        }
    }

    @Override
    public void onLoadmoreCanceled() {
        if (this.refreshListener != null) {
            this.refreshListener.onLoadmoreCanceled();
        }
    }

    public class CoContext {
        private AnimProcessor animProcessor = new AnimProcessor(this);
        private static final int PULLING_TOP_DOWN = 0;
        private static final int PULLING_BOTTOM_UP = 1;
        private int state = 0;
        private static final int EX_MODE_NORMAL = 0;
        private static final int EX_MODE_FIXED = 1;
        private int exHeadMode = 0;
        private boolean isExHeadLocked = true;

        public void init() {
            if (VerticalRefreshLayout.this.isPureScrollModeOn) {
                VerticalRefreshLayout.this.setOverScrollTopShow(false);
                VerticalRefreshLayout.this.setOverScrollBottomShow(false);
                if (VerticalRefreshLayout.this.mHeadLayout != null) {
                    VerticalRefreshLayout.this.mHeadLayout.setVisibility(8);
                }
                if (VerticalRefreshLayout.this.mBottomLayout != null) {
                    VerticalRefreshLayout.this.mBottomLayout.setVisibility(8);
                }
            }
        }

        public AnimProcessor getAnimProcessor() {
            return this.animProcessor;
        }

        public float getMaxHeadHeight() {
            return VerticalRefreshLayout.this.mMaxHeadHeight;
        }

        public int getHeadHeight() {
            return (int)VerticalRefreshLayout.this.mHeadHeight;
        }

        public int getExtraHeadHeight() {
            return VerticalRefreshLayout.this.mExtraHeadLayout.getHeight();
        }

        public int getMaxBottomHeight() {
            return (int)VerticalRefreshLayout.this.mMaxBottomHeight;
        }

        public int getBottomHeight() {
            return (int)VerticalRefreshLayout.this.mBottomHeight;
        }

        public int getOsHeight() {
            return (int)VerticalRefreshLayout.this.mOverScrollHeight;
        }

        public View getTargetView() {
            return VerticalRefreshLayout.this.mChildView;
        }

        public View getHeader() {
            return VerticalRefreshLayout.this.mHeadLayout;
        }

        public View getFooter() {
            return VerticalRefreshLayout.this.mBottomLayout;
        }

        public int getTouchSlop() {
            return VerticalRefreshLayout.this.mTouchSlop;
        }

        public void resetHeaderView() {
            if (VerticalRefreshLayout.this.mHeadView != null) {
                VerticalRefreshLayout.this.mHeadView.reset();
            }
        }

        public void resetBottomView() {
            if (VerticalRefreshLayout.this.mBottomView != null) {
                VerticalRefreshLayout.this.mBottomView.reset();
            }
        }

        public View getExHead() {
            return VerticalRefreshLayout.this.mExtraHeadLayout;
        }

        public void setExHeadNormal() {
            this.exHeadMode = 0;
        }

        public void setExHeadFixed() {
            this.exHeadMode = 1;
        }

        public boolean isExHeadNormal() {
            return this.exHeadMode == 0;
        }

        public boolean isExHeadFixed() {
            return this.exHeadMode == 1;
        }

        public boolean isExHeadLocked() {
            return this.isExHeadLocked;
        }

        public void onAddExHead() {
            this.isExHeadLocked = false;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)VerticalRefreshLayout.this.mChildView.getLayoutParams();
            params.addRule(3, VerticalRefreshLayout.this.mExtraHeadLayout.getId());
            VerticalRefreshLayout.this.mChildView.setLayoutParams((ViewGroup.LayoutParams)params);
            VerticalRefreshLayout.this.requestLayout();
        }

        public void startRefresh() {
            VerticalRefreshLayout.this.post(new Runnable(){

                @Override
                public void run() {
                    CoContext.this.setStatePTD();
                    if (!VerticalRefreshLayout.this.isPureScrollModeOn && VerticalRefreshLayout.this.mChildView != null) {
                        CoContext.this.setRefreshing(true);
                        CoContext.this.animProcessor.animHeadToRefresh();
                    }
                }
            });
        }

        public void startLoadMore() {
            VerticalRefreshLayout.this.post(new Runnable(){

                @Override
                public void run() {
                    CoContext.this.setStatePBU();
                    if (!VerticalRefreshLayout.this.isPureScrollModeOn && VerticalRefreshLayout.this.mChildView != null) {
                        CoContext.this.setLoadingMore(true);
                        CoContext.this.animProcessor.animBottomToLoad();
                    }
                }
            });
        }

        public void finishRefreshing() {
            this.onFinishRefresh();
        }

        public void finishRefreshAfterAnim() {
            if (this.isRefreshVisible() && VerticalRefreshLayout.this.mChildView != null) {
                this.setRefreshing(false);
                this.animProcessor.animHeadBack();
            }
        }

        public void finishLoadmore() {
            this.onFinishLoadMore();
            if (this.isLoadingVisible() && VerticalRefreshLayout.this.mChildView != null) {
                this.setLoadingMore(false);
                this.animProcessor.animBottomBack();
            }
        }

        public boolean enableOverScroll() {
            return VerticalRefreshLayout.this.enableOverScroll;
        }

        public boolean allowPullDown() {
            return VerticalRefreshLayout.this.enableRefresh || VerticalRefreshLayout.this.enableOverScroll;
        }

        public boolean allowPullUp() {
            return VerticalRefreshLayout.this.enableLoadmore || VerticalRefreshLayout.this.enableOverScroll;
        }

        public boolean enableRefresh() {
            return VerticalRefreshLayout.this.enableRefresh;
        }

        public boolean enableLoadmore() {
            return VerticalRefreshLayout.this.enableLoadmore;
        }

        public boolean allowOverScroll() {
            return !VerticalRefreshLayout.this.isRefreshVisible && !VerticalRefreshLayout.this.isLoadingVisible;
        }

        public boolean isRefreshVisible() {
            return VerticalRefreshLayout.this.isRefreshVisible;
        }

        public boolean isLoadingVisible() {
            return VerticalRefreshLayout.this.isLoadingVisible;
        }

        public void setRefreshing(boolean refreshing) {
            VerticalRefreshLayout.this.isRefreshVisible = refreshing;
        }

        public void setLoadingMore(boolean loadingMore) {
            VerticalRefreshLayout.this.isLoadingVisible = loadingMore;
        }

        public boolean isOpenFloatRefresh() {
            return VerticalRefreshLayout.this.floatRefresh;
        }

        public boolean autoLoadMore() {
            return VerticalRefreshLayout.this.autoLoadMore;
        }

        public boolean isPureScrollModeOn() {
            return VerticalRefreshLayout.this.isPureScrollModeOn;
        }

        public boolean isOverScrollTopShow() {
            return VerticalRefreshLayout.this.isOverScrollTopShow;
        }

        public boolean isOverScrollBottomShow() {
            return VerticalRefreshLayout.this.isOverScrollBottomShow;
        }

        public void onPullingDown(float offsetY) {
            VerticalRefreshLayout.this.pullListener.onPullingDown(VerticalRefreshLayout.this, offsetY / VerticalRefreshLayout.this.mHeadHeight);
        }

        public void onPullingUp(float offsetY) {
            VerticalRefreshLayout.this.pullListener.onPullingUp(VerticalRefreshLayout.this, offsetY / VerticalRefreshLayout.this.mBottomHeight);
        }

        public void onRefresh() {
            VerticalRefreshLayout.this.pullListener.onRefresh(VerticalRefreshLayout.this);
        }

        public void onLoadMore() {
            VerticalRefreshLayout.this.pullListener.onLoadMore(VerticalRefreshLayout.this);
        }

        public void onFinishRefresh() {
            VerticalRefreshLayout.this.pullListener.onFinishRefresh();
        }

        public void onFinishLoadMore() {
            VerticalRefreshLayout.this.pullListener.onFinishLoadMore();
        }

        public void onPullDownReleasing(float offsetY) {
            VerticalRefreshLayout.this.pullListener.onPullDownReleasing(VerticalRefreshLayout.this, offsetY / VerticalRefreshLayout.this.mHeadHeight);
        }

        public void onPullUpReleasing(float offsetY) {
            VerticalRefreshLayout.this.pullListener.onPullUpReleasing(VerticalRefreshLayout.this, offsetY / VerticalRefreshLayout.this.mBottomHeight);
        }

        public void onRefreshCanceled() {
            VerticalRefreshLayout.this.pullListener.onRefreshCanceled();
        }

        public void onLoadmoreCanceled() {
            VerticalRefreshLayout.this.pullListener.onLoadmoreCanceled();
        }

        public void setStatePTD() {
            this.state = 0;
        }

        public void setStatePBU() {
            this.state = 1;
        }

        public boolean isStatePTD() {
            return 0 == this.state;
        }

        public boolean isStatePBU() {
            return 1 == this.state;
        }
    }
}

