/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.recview;

import android.content.Context;
import android.util.AttributeSet;
import com.gymchina.android.recview.listener.IRefreshLayout;
import com.gymchina.android.recview.listener.OnPullDownListener;
import com.gymchina.android.vrefresh.RefreshListenerAdapter;
import com.gymchina.android.vrefresh.VerticalRefreshLayout;
import com.gymchina.android.vrefresh.footer.BallPulseView;
import com.gymchina.android.vrefresh.header.progresslayout.ProgressLayout;

public class VRefreshLayout
extends VerticalRefreshLayout
implements IRefreshLayout {
    private Context mContext;
    private OnPullDownListener mListener;

    public VRefreshLayout(Context context) {
        super(context);
        this.init(context);
    }

    public VRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public VRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setHeaderHeight(50.0f);
        this.setBottomHeight(50.0f);
        this.setHeaderView(new ProgressLayout(this.mContext));
        BallPulseView ballPulseViewRes = new BallPulseView(this.mContext);
        ballPulseViewRes.setNormalColor(-16711936);
        ballPulseViewRes.setAnimatingColor(-16711936);
        this.setBottomView(ballPulseViewRes);
        this.setOnRefreshListener(new RefreshListenerAdapter(){

            @Override
            public void onRefresh(VerticalRefreshLayout refreshLayout) {
                if (VRefreshLayout.this.mListener != null) {
                    VRefreshLayout.this.mListener.onRefresh();
                }
            }

            @Override
            public void onLoadMore(VerticalRefreshLayout refreshLayout) {
                if (VRefreshLayout.this.mListener != null) {
                    VRefreshLayout.this.mListener.onLoadMore();
                }
            }
        });
    }

    @Override
    public void setOnPullDownListener(OnPullDownListener listener) {
        this.mListener = listener;
    }

    @Override
    public void enableRefreshLoad(boolean enable) {
        this.setEnableRefresh(enable);
        this.setEnableLoadMore(enable);
    }

    @Override
    public void setEnableRefresh(boolean enable) {
        super.setEnableRefresh(enable);
    }

    @Override
    public void setEnableLoadMore(boolean enable) {
        super.setEnableLoadmore(enable);
    }

    @Override
    public void setAutoLoadMore(boolean autoLoad) {
        super.setAutoLoadMore(autoLoad);
    }

    @Override
    public void startAutoRefresh() {
        super.startRefresh();
    }

    @Override
    public void startAutoLoadMore() {
        super.startLoadMore();
    }

    @Override
    public void handlerComplete() {
        this.refreshComplete();
        this.loadMoreComplete();
    }

    @Override
    public void refreshComplete() {
        super.finishRefreshing();
    }

    @Override
    public void loadMoreComplete() {
        super.finishLoadmore();
    }
}

