/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.recview;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.recview.AbsRecyclerView;
import com.gymchina.android.recview.LRefreshLayout;
import com.gymchina.android.recview.R;
import com.gymchina.android.recview.VRefreshLayout;
import com.gymchina.android.recview.adapter.HFRecAdapter;
import com.gymchina.android.recview.decoration.HfItemDecoration;
import com.gymchina.android.recview.listener.OnPullDownListener;
import com.gymchina.android.recview.listener.OnRefreshScrollListener;

public final class RecView
extends FrameLayout {
    private static final String TAG = RecView.class.getSimpleName();
    private REFRESH_MODE mRefreshMode = REFRESH_MODE.VERTICAL;
    private Context mContext;
    private HFRecAdapter mAdapter;
    private AbsRecyclerView mRecyclerView;
    private VRefreshLayout mVerRefreshLayout;
    private LRefreshLayout mLandRefreshLayout;
    private RecyclerView.ItemDecoration mItemDecoration;
    private RecyclerView.OnScrollListener mRecOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            block4: {
                RecyclerView.LayoutManager layoutManager;
                block5: {
                    int totalItemCount;
                    block3: {
                        super.onScrolled(recyclerView, dx, dy);
                        layoutManager = recyclerView.getLayoutManager();
                        totalItemCount = layoutManager.getItemCount();
                        if (!(layoutManager instanceof GridLayoutManager)) break block3;
                        int lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
                        int firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
                        if (firstVisibleItemPosition == 0 || lastVisibleItemPosition != totalItemCount - 1) break block4;
                        RecView.this.startAutoLoadMore();
                        break block4;
                    }
                    if (!(layoutManager instanceof LinearLayoutManager)) break block5;
                    int lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
                    int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
                    if (firstVisibleItemPosition == 0 || lastVisibleItemPosition != totalItemCount - 1) break block4;
                    RecView.this.startAutoLoadMore();
                    break block4;
                }
                if (layoutManager instanceof StaggeredGridLayoutManager) {
                    int[] lastOut = ((StaggeredGridLayoutManager)layoutManager).findLastCompletelyVisibleItemPositions(null);
                    int[] firstOut = ((StaggeredGridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPositions(null);
                    int lastPosition = layoutManager.getItemCount() - 1;
                    block0: for (int lastPos : lastOut) {
                        if (lastPos != lastPosition) continue;
                        for (int firstPos : firstOut) {
                            if (firstPos == 0) continue;
                            RecView.this.startAutoLoadMore();
                            break block0;
                        }
                    }
                }
                break block4;
                {
                    break;
                }
            }
        }
    };

    public RecView(Context context) {
        super(context);
        this.init(context);
    }

    public RecView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @TargetApi(value=11)
    public RecView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public RecView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
    }

    private void initRecyclerView() {
        if (this.mRecyclerView == null) {
            return;
        }
        this.mRecyclerView.setHasFixedSize(true);
        if (this.mRecyclerView.getLayoutParams() == null) {
            this.mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        }
    }

    @Nullable
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Nullable
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView.getLayoutManager();
    }

    @Nullable
    public HFRecAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        if (layout2 == null) {
            return;
        }
        if (layout2.canScrollVertically()) {
            this.setVerRefreshMode();
        } else if (layout2.canScrollHorizontally()) {
            this.setLandRefreshMode();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setLayoutManager(layout2);
            if (this.mItemDecoration != null) {
                this.addItemDecoration(this.mItemDecoration);
            } else if (this.mAdapter != null) {
                this.setAdapter(this.mAdapter);
            }
        }
    }

    public void addItemDecoration(RecyclerView.ItemDecoration decoration) {
        this.mItemDecoration = decoration;
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addItemDecoration(this.mItemDecoration);
        }
        if (this.mAdapter != null && this.mItemDecoration instanceof HfItemDecoration) {
            ((HfItemDecoration)this.mItemDecoration).setHFAdapter(this.mAdapter);
        }
    }

    public void setAdapter(HFRecAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mItemDecoration instanceof HfItemDecoration) {
            ((HfItemDecoration)this.mItemDecoration).setHFAdapter(this.mAdapter);
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setAdapter(this.mAdapter);
        }
    }

    private void setVerRefreshMode() {
        this.mRefreshMode = REFRESH_MODE.VERTICAL;
        if (this.mLandRefreshLayout != null) {
            this.mLandRefreshLayout.removeAllViews();
            this.mLandRefreshLayout = null;
        }
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.recview_verrefesh_layout, null);
        this.mVerRefreshLayout = (VRefreshLayout)rootView.findViewById(R.id.gym_refresh_layout);
        this.mRecyclerView = (AbsRecyclerView)rootView.findViewById(R.id.gym_recycler_view);
        this.initRecyclerView();
        this.removeAllViews();
        this.addView((View)this.mVerRefreshLayout);
    }

    private void setLandRefreshMode() {
        this.mRefreshMode = REFRESH_MODE.LANDSCAPE;
        if (this.mVerRefreshLayout != null) {
            this.mVerRefreshLayout.removeAllViews();
            this.mVerRefreshLayout = null;
        }
        if (this.mLandRefreshLayout != null) {
            this.mLandRefreshLayout.removeAllViews();
        } else {
            this.mLandRefreshLayout = new LRefreshLayout(this.mContext);
            this.mLandRefreshLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        }
        this.mRecyclerView = new AbsRecyclerView(this.mContext);
        this.initRecyclerView();
        this.mLandRefreshLayout.addView((View)this.mRecyclerView);
        this.removeAllViews();
        this.addView((View)this.mLandRefreshLayout);
    }

    public void addOnScrollListener(RecyclerView.OnScrollListener listener) {
        if (this.mRecyclerView == null) {
            return;
        }
        if (listener != null) {
            this.mRecyclerView.addOnScrollListener(listener);
        }
    }

    public void removeOnScrollListener(RecyclerView.OnScrollListener listener) {
        if (this.mRecyclerView == null) {
            return;
        }
        if (listener != null) {
            this.mRecyclerView.removeOnScrollListener(listener);
        }
    }

    public void setRefreshScrollListener(final OnRefreshScrollListener listener) {
        if (this.mRefreshMode != REFRESH_MODE.VERTICAL && this.mRefreshMode == REFRESH_MODE.LANDSCAPE && this.mLandRefreshLayout != null) {
            this.mLandRefreshLayout.setRefreshScrollListener(listener);
        }
        if (listener != null) {
            this.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    if (listener != null) {
                        listener.onScrolledOnRefresh(dx, dy, 0);
                    }
                }
            });
        }
    }

    public void setOnPullDownListener(OnPullDownListener listener) {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.setOnPullDownListener(listener);
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.setOnPullDownListener(listener);
        }
    }

    public void smoothScrollToPosition(int index) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.smoothScrollToPosition(index);
        }
    }

    public void scrollToPosition(int position) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollToPosition(position);
        }
    }

    public void scrollBy(int dx, int dy) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollBy(dx, dy);
        }
    }

    public void enableRefreshLoad(boolean enable) {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.enableRefreshLoad(enable);
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.enableRefreshLoad(enable);
        }
    }

    public void setEnableRefresh(boolean enable) {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.setEnableRefresh(enable);
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.setEnableRefresh(enable);
        }
    }

    public void setEnableLoadMore(boolean enable) {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.setEnableLoadMore(enable);
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.setEnableLoadMore(enable);
        }
    }

    public void setAutoLoadMore(boolean autoLoad) {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.setAutoLoadMore(autoLoad);
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE && this.mRecyclerView != null) {
            if (autoLoad) {
                this.mRecyclerView.addOnScrollListener(this.mRecOnScrollListener);
            } else {
                this.mRecyclerView.removeOnScrollListener(this.mRecOnScrollListener);
            }
        }
    }

    public void startAutoRefresh() {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.startAutoRefresh();
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.startAutoRefresh();
        }
    }

    public void startAutoLoadMore() {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.startAutoLoadMore();
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.startAutoLoadMore();
        }
    }

    public void handlerComplete() {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.handlerComplete();
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.handlerComplete();
        }
    }

    public void refreshComplete() {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.refreshComplete();
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.refreshComplete();
        }
    }

    public void loadMoreComplete() {
        if (this.mRefreshMode == REFRESH_MODE.VERTICAL) {
            this.mVerRefreshLayout.loadMoreComplete();
        } else if (this.mRefreshMode == REFRESH_MODE.LANDSCAPE) {
            this.mLandRefreshLayout.loadMoreComplete();
        }
    }

    protected static enum REFRESH_MODE {
        VERTICAL,
        LANDSCAPE;

    }
}

