/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.lrefresh.header;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.lrefresh.RefreshHeader;
import com.gymchina.android.lrefresh.widget.CircleImageView;
import com.gymchina.android.lrefresh.widget.MaterialProgressDrawable;
import com.gymchina.android.recview.R;

public class MaterialRefreshHeader
implements RefreshHeader {
    private final int startOrEnd;
    private CircleImageView mCircleView;
    private MaterialProgressDrawable mProgress;
    private ViewGroup parent;

    public MaterialRefreshHeader(int startOrEnd) {
        this.startOrEnd = startOrEnd;
    }

    @Override
    public void onStart(int dragPosition, View refreshHead) {
        this.mProgress.stop();
        this.mProgress.showArrow(false);
        this.mProgress.setAlpha(0);
        this.mProgress.setStartEndTrim(0.0f, 0.0f);
    }

    @Override
    public void onDragging(float distance, float percent, View refreshHead) {
        this.mProgress.showArrow(true);
        this.mProgress.setAlpha((int)(percent * 255.0f));
        this.mProgress.setProgressRotation(percent);
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, percent));
    }

    @Override
    public void onReadyToRelease(View refreshHead) {
    }

    @Override
    @NonNull
    public View getView(ViewGroup container) {
        this.parent = container;
        ViewGroup view = (ViewGroup)LayoutInflater.from((Context)container.getContext()).inflate(R.layout.lrefresh_material_refresh_header, container, false);
        this.mCircleView = new CircleImageView(container.getContext(), -328966, 20.0f);
        this.mProgress = new MaterialProgressDrawable(container.getContext(), (View)container);
        this.mProgress.setBackgroundColor(-328966);
        this.mCircleView.setImageDrawable(this.mProgress);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = this.startOrEnd == 0 ? 17 : 17;
        this.mCircleView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        view.addView((View)this.mCircleView);
        return view;
    }

    @Override
    public void onRefreshing(View refreshHead) {
        this.mProgress.showArrow(true);
        this.mProgress.setAlpha(255);
        this.mProgress.setProgressRotation(1.0f);
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, 1.0f));
        this.mProgress.start();
    }
}

