/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.groupadapter.adapter;

import android.content.Context;
import com.gymchina.android.groupadapter.core.adapter.GroupedRecyclerViewAdapter;
import com.gymchina.android.groupadapter.core.holder.BaseViewHolder;
import com.gymchina.android.groupadapter.entity.GroupEntity;
import java.util.ArrayList;

public abstract class AbsExpandableAdapter<T extends GroupEntity>
extends GroupedRecyclerViewAdapter {
    protected ArrayList<T> mGroups;

    public AbsExpandableAdapter(Context context, ArrayList<T> groups) {
        super(context);
        this.mGroups = groups;
    }

    @Override
    public int getGroupCount() {
        return this.mGroups == null ? 0 : this.mGroups.size();
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        if (!this.isExpand(groupPosition)) {
            return 0;
        }
        ArrayList children = ((GroupEntity)this.mGroups.get(groupPosition)).getChildren();
        return children == null ? 0 : children.size();
    }

    @Override
    public boolean hasHeader(int groupPosition) {
        return true;
    }

    @Override
    public boolean hasFooter(int groupPosition) {
        return false;
    }

    @Override
    public int getFooterLayout(int viewType) {
        return 0;
    }

    @Override
    public void onBindFooterViewHolder(BaseViewHolder holder, int groupPosition) {
    }

    public boolean isExpand(int groupPosition) {
        GroupEntity entity = (GroupEntity)this.mGroups.get(groupPosition);
        return entity.isExpand();
    }

    public void expandGroup(int groupPosition) {
        this.expandGroup(groupPosition, false);
    }

    public void expandGroup(int groupPosition, boolean animate) {
        GroupEntity entity = (GroupEntity)this.mGroups.get(groupPosition);
        entity.setExpand(true);
        if (animate) {
            this.notifyChildrenInserted(groupPosition);
        } else {
            this.notifyDataChanged();
        }
    }

    public void collapseGroup(int groupPosition) {
        this.collapseGroup(groupPosition, false);
    }

    public void collapseGroup(int groupPosition, boolean animate) {
        GroupEntity entity = (GroupEntity)this.mGroups.get(groupPosition);
        entity.setExpand(false);
        if (animate) {
            this.notifyChildrenRemoved(groupPosition);
        } else {
            this.notifyDataChanged();
        }
    }
}

