/*
 * Decompiled with CFR 0.152.
 */
package com.donkingliang.groupedadapter.widget;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gymchina.android.groupadapter.core.adapter.GroupedRecyclerViewAdapter;
import com.gymchina.android.groupadapter.core.holder.BaseViewHolder;
import java.lang.reflect.Method;

public class StickyHeaderLayout
extends FrameLayout {
    private Context mContext;
    private RecyclerView mRecyclerView;
    private FrameLayout mStickyLayout;
    private final SparseArray<BaseViewHolder> mStickyViews = new SparseArray();
    private final int VIEW_TAG_TYPE = -101;
    private final int VIEW_TAG_HOLDER = -102;
    private int mCurrentStickyGroup = -1;
    private boolean isSticky = true;
    private boolean isRegisterDataObserver = false;

    public StickyHeaderLayout(@NonNull Context context) {
        super(context);
        this.mContext = context;
    }

    public StickyHeaderLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public StickyHeaderLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0 || !(child instanceof RecyclerView)) {
            throw new IllegalArgumentException("StickyHeaderLayout can host only one direct child --> RecyclerView");
        }
        super.addView(child, index, params);
        this.mRecyclerView = (RecyclerView)child;
        this.addOnScrollListener();
        this.addStickyLayout();
    }

    private void addOnScrollListener() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (StickyHeaderLayout.this.isSticky) {
                    StickyHeaderLayout.this.updateStickyView(false);
                }
            }
        });
    }

    private void addStickyLayout() {
        this.mStickyLayout = new FrameLayout(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
        this.mStickyLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        super.addView((View)this.mStickyLayout, 1, (ViewGroup.LayoutParams)lp);
    }

    private void updateStickyView(boolean imperative) {
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter instanceof GroupedRecyclerViewAdapter) {
            GroupedRecyclerViewAdapter gAdapter = (GroupedRecyclerViewAdapter)adapter;
            this.registerAdapterDataObserver(gAdapter);
            int firstVisibleItem = this.getFirstVisibleItem();
            int groupPosition = gAdapter.getGroupPositionForPosition(firstVisibleItem);
            if (imperative || this.mCurrentStickyGroup != groupPosition) {
                this.mCurrentStickyGroup = groupPosition;
                int groupHeaderPosition = gAdapter.getPositionForGroupHeader(groupPosition);
                if (groupHeaderPosition != -1) {
                    boolean flag;
                    int viewType = gAdapter.getItemViewType(groupHeaderPosition);
                    BaseViewHolder holder = this.recycleStickyView(viewType);
                    boolean bl = flag = holder != null;
                    if (holder == null) {
                        holder = this.getStickyViewByType(viewType);
                    }
                    if (holder == null) {
                        holder = (BaseViewHolder)gAdapter.onCreateViewHolder((ViewGroup)this.mStickyLayout, viewType);
                        holder.itemView.setTag(-101, (Object)viewType);
                        holder.itemView.setTag(-102, (Object)holder);
                    }
                    gAdapter.onBindViewHolder(holder, groupHeaderPosition);
                    if (!flag) {
                        this.mStickyLayout.addView(holder.itemView);
                    }
                } else {
                    this.recycle();
                }
            }
            if (this.mStickyLayout.getChildCount() > 0 && this.mStickyLayout.getHeight() == 0) {
                this.mStickyLayout.requestLayout();
            }
            this.mStickyLayout.setTranslationY(this.calculateOffset(gAdapter, firstVisibleItem, groupPosition + 1));
        }
    }

    private void registerAdapterDataObserver(GroupedRecyclerViewAdapter adapter) {
        if (!this.isRegisterDataObserver) {
            this.isRegisterDataObserver = true;
            adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                public void onChanged() {
                    StickyHeaderLayout.this.updateStickyViewDelayed();
                }

                public void onItemRangeChanged(int positionStart, int itemCount) {
                    StickyHeaderLayout.this.updateStickyViewDelayed();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    StickyHeaderLayout.this.updateStickyViewDelayed();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    StickyHeaderLayout.this.updateStickyViewDelayed();
                }
            });
        }
    }

    private void updateStickyViewDelayed() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                StickyHeaderLayout.this.updateStickyView(true);
            }
        }, 100L);
    }

    private BaseViewHolder recycleStickyView(int viewType) {
        if (this.mStickyLayout.getChildCount() > 0) {
            View view = this.mStickyLayout.getChildAt(0);
            int type = (Integer)view.getTag(-101);
            if (type == viewType) {
                return (BaseViewHolder)((Object)view.getTag(-102));
            }
            this.recycle();
        }
        return null;
    }

    private void recycle() {
        if (this.mStickyLayout.getChildCount() > 0) {
            View view = this.mStickyLayout.getChildAt(0);
            this.mStickyViews.put(((Integer)view.getTag(-101)).intValue(), (Object)((BaseViewHolder)((Object)view.getTag(-102))));
            this.mStickyLayout.removeAllViews();
        }
    }

    private BaseViewHolder getStickyViewByType(int viewType) {
        return (BaseViewHolder)((Object)this.mStickyViews.get(viewType));
    }

    private float calculateOffset(GroupedRecyclerViewAdapter gAdapter, int firstVisibleItem, int groupPosition) {
        int groupHeaderPosition = gAdapter.getPositionForGroupHeader(groupPosition);
        if (groupHeaderPosition != -1) {
            View view;
            float off;
            int index = groupHeaderPosition - firstVisibleItem;
            if (this.mRecyclerView.getChildCount() > index && (off = (view = this.mRecyclerView.getChildAt(index)).getY() - (float)this.mStickyLayout.getHeight()) < 0.0f) {
                return off;
            }
        }
        return 0.0f;
    }

    private int getFirstVisibleItem() {
        int firstVisibleItem = -1;
        RecyclerView.LayoutManager layout = this.mRecyclerView.getLayoutManager();
        if (layout != null) {
            if (layout instanceof GridLayoutManager) {
                firstVisibleItem = ((GridLayoutManager)layout).findFirstVisibleItemPosition();
            } else if (layout instanceof LinearLayoutManager) {
                firstVisibleItem = ((LinearLayoutManager)layout).findFirstVisibleItemPosition();
            } else if (layout instanceof StaggeredGridLayoutManager) {
                int[] firstPositions = new int[((StaggeredGridLayoutManager)layout).getSpanCount()];
                ((StaggeredGridLayoutManager)layout).findFirstVisibleItemPositions(firstPositions);
                firstVisibleItem = this.getMin(firstPositions);
            }
        }
        return firstVisibleItem;
    }

    private int getMin(int[] arr) {
        int min = arr[0];
        for (int x = 1; x < arr.length; ++x) {
            if (arr[x] >= min) continue;
            min = arr[x];
        }
        return min;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    public void setSticky(boolean sticky) {
        if (this.isSticky != sticky) {
            this.isSticky = sticky;
            if (this.mStickyLayout != null) {
                if (this.isSticky) {
                    this.mStickyLayout.setVisibility(0);
                    this.updateStickyView(false);
                } else {
                    this.recycle();
                    this.mStickyLayout.setVisibility(8);
                }
            }
        }
    }

    protected int computeVerticalScrollOffset() {
        if (this.mRecyclerView != null) {
            try {
                Method method = View.class.getDeclaredMethod("computeVerticalScrollOffset", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.mRecyclerView, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.computeVerticalScrollOffset();
    }

    protected int computeVerticalScrollRange() {
        if (this.mRecyclerView != null) {
            try {
                Method method = View.class.getDeclaredMethod("computeVerticalScrollRange", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.mRecyclerView, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.computeVerticalScrollRange();
    }

    protected int computeVerticalScrollExtent() {
        if (this.mRecyclerView != null) {
            try {
                Method method = View.class.getDeclaredMethod("computeVerticalScrollExtent", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke((Object)this.mRecyclerView, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.computeVerticalScrollExtent();
    }

    public void scrollBy(int x, int y) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollBy(x, y);
        } else {
            super.scrollBy(x, y);
        }
    }

    public void scrollTo(int x, int y) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.scrollTo(x, y);
        } else {
            super.scrollTo(x, y);
        }
    }
}

