/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.network.abs;

import android.os.Build;
import android.support.annotation.NonNull;
import com.gymchina.android.common.utils.AppUtil;
import com.gymchina.android.framework.network.api.BaseApi;
import com.gymchina.android.framework.network.interceptor.BasicParamsInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class AbsNetClient {
    protected final int CONNECT_TIMEOUT = 20;
    protected final int WRITE_TIMEOUT = 15;
    protected final int READ_TIMEOUT = 15;

    public <T> T getApi(@NonNull BaseApi<T> baseApi) {
        return this.createService(baseApi);
    }

    private <T> T createService(@NonNull BaseApi<T> baseApi) {
        return (T)this.createRetrofit(baseApi).create(baseApi.getServiceClass());
    }

    protected <T> Retrofit createRetrofit(@NonNull BaseApi<T> baseApi) {
        return new Retrofit.Builder().baseUrl(baseApi.getBaseUrl()).client(this.getOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    protected List<String> getBasicHeader() {
        return new ArrayList<String>();
    }

    protected HashMap<String, String> getBasicParams() {
        HashMap<String, String> basicMap = new HashMap<String, String>();
        basicMap.put("appVersion", AppUtil.getVersionName());
        basicMap.put("brand", Build.BRAND);
        basicMap.put("model", Build.MODEL);
        return basicMap;
    }

    protected BasicParamsInterceptor getBasicInterceptor() {
        return new BasicParamsInterceptor.Builder().addQueryParamsMap(this.getBasicParams()).addHeaderLinesList(this.getBasicHeader()).build();
    }

    protected OkHttpClient getOkHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)this.getBasicInterceptor()).build();
    }

    public void reset() {
    }
}

