/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.base;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;

public abstract class LazyLoadFragment
extends Fragment {
    private static final String TAG = LazyLoadFragment.class.getSimpleName();
    private boolean isFirstEnter = true;
    private boolean isReuseView = true;
    private boolean isFragmentVisible;
    private View rootView;

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (this.rootView == null) {
            return;
        }
        if (this.isFirstEnter && isVisibleToUser) {
            this.onFragmentFirstVisible();
            this.isFirstEnter = false;
        }
        if (isVisibleToUser) {
            this.isFragmentVisible = true;
            this.onFragmentVisibleChange(this.isFragmentVisible);
            return;
        }
        if (this.isFragmentVisible) {
            this.isFragmentVisible = false;
            this.onFragmentVisibleChange(this.isFragmentVisible);
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = view;
            if (this.getUserVisibleHint()) {
                if (this.isFirstEnter) {
                    this.onFragmentFirstVisible();
                    this.isFirstEnter = false;
                }
                this.onFragmentVisibleChange(true);
                this.isFragmentVisible = true;
            }
        }
        super.onViewCreated(this.isReuseView ? this.rootView : view, savedInstanceState);
    }

    protected void reuseView(boolean isReuse) {
        this.isReuseView = isReuse;
    }

    protected void onFragmentVisibleChange(boolean isVisible) {
    }

    protected void onFragmentFirstVisible() {
    }

    protected boolean isFragmentVisible() {
        return this.isFragmentVisible;
    }

    private void resetVariavle() {
        this.isFirstEnter = true;
        this.isReuseView = true;
        this.isFragmentVisible = false;
    }

    public void onDestroy() {
        super.onDestroy();
        this.resetVariavle();
    }
}

