/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.common.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;

public final class TaskUtil {
    private static Thread mMainThread;
    private static long mMainThreadId;
    private static Looper mMainLooper;
    private static Handler mHandler;

    private TaskUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void init() {
        mMainThread = Thread.currentThread();
        mMainThreadId = Process.myTid();
        mMainLooper = Looper.getMainLooper();
        mHandler = new Handler(mMainLooper);
    }

    public static Thread getMainThread() {
        return mMainThread;
    }

    public static void setMainThread(Thread mMainThread) {
        TaskUtil.mMainThread = mMainThread;
    }

    public static long getMainThreadId() {
        return mMainThreadId;
    }

    public static void setMainThreadId(long mMainThreadId) {
        TaskUtil.mMainThreadId = mMainThreadId;
    }

    public static Looper getMainThreadLooper() {
        return mMainLooper;
    }

    public static void setMainThreadLooper(Looper mMainLooper) {
        TaskUtil.mMainLooper = mMainLooper;
    }

    public static Handler getMainHandler() {
        return mHandler;
    }

    public static void setMainHandler(Handler mHandler) {
        TaskUtil.mHandler = mHandler;
    }

    public static void postTaskDelay(Runnable task, long delayMillis) {
        TaskUtil.getMainHandler().postDelayed(task, delayMillis);
    }

    public static void postTask(Runnable task) {
        int curThreadId = Process.myTid();
        if ((long)curThreadId == TaskUtil.getMainThreadId()) {
            task.run();
        } else {
            TaskUtil.getMainHandler().post(task);
        }
    }

    public static void removeTask(Runnable task) {
        TaskUtil.getMainHandler().removeCallbacks(task);
    }

    public static void clearTask() {
        TaskUtil.getMainThread().stop();
        TaskUtil.getMainHandler().removeCallbacksAndMessages(null);
    }
}

