/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.common.utils;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.gymchina.android.common.App;
import com.gymchina.android.common.utils.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class NetInfoUtil {
    private static ConnectivityManager sConnectivityManager;

    private NetInfoUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    private static void init(Context context) {
        if (sConnectivityManager != null) {
            return;
        }
        try {
            if (context == null) {
                context = App.instance();
            }
            sConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
        catch (Exception e) {
            LogUtil.e(e);
        }
    }

    public static boolean isConnected(Context context) {
        NetInfoUtil.init(context);
        try {
            NetworkInfo network = sConnectivityManager.getActiveNetworkInfo();
            return network != null && (network.isConnected() || network.getState() == NetworkInfo.State.CONNECTING);
        }
        catch (Exception e) {
            LogUtil.e(e);
            return false;
        }
    }

    public static boolean isWifiAvailable() {
        NetInfoUtil.init(null);
        try {
            NetworkInfo mobNetInfo = sConnectivityManager.getActiveNetworkInfo();
            return mobNetInfo != null && mobNetInfo.isAvailable() && mobNetInfo.getType() == 1;
        }
        catch (Exception e) {
            LogUtil.e(e);
            return false;
        }
    }

    public static boolean isMobileAvailable() {
        NetInfoUtil.init(null);
        try {
            NetworkInfo mobNetInfo = sConnectivityManager.getActiveNetworkInfo();
            return mobNetInfo != null && mobNetInfo.isAvailable() && mobNetInfo.getType() == 0;
        }
        catch (Exception e) {
            LogUtil.e(e);
            return false;
        }
    }

    public static int getNetType() {
        NetInfoUtil.init(null);
        int netType = -1;
        try {
            NetworkInfo mobNetInfo = sConnectivityManager.getActiveNetworkInfo();
            if (mobNetInfo != null && mobNetInfo.isAvailable()) {
                netType = mobNetInfo.getType();
            }
        }
        catch (Exception e) {
            LogUtil.e(e);
        }
        return netType;
    }

    public static String getNetMode() {
        NetInfoUtil.init(null);
        String netMode = "none";
        try {
            NetworkInfo mobNetInfo = sConnectivityManager.getActiveNetworkInfo();
            if (mobNetInfo != null && mobNetInfo.isAvailable()) {
                int netType = mobNetInfo.getType();
                if (netType == 1) {
                    netMode = mobNetInfo.getTypeName();
                } else if (netType == 0) {
                    netMode = mobNetInfo.getExtraInfo();
                }
            }
        }
        catch (Exception e) {
            LogUtil.e(e);
        }
        if (netMode == null) {
            netMode = "none";
        }
        return netMode;
    }

    @Deprecated
    public static int getLinkSpeed(Context context) {
        try {
            WifiInfo info = ((WifiManager)context.getSystemService("wifi")).getConnectionInfo();
            return info.getLinkSpeed();
        }
        catch (Exception e) {
            LogUtil.e(e);
            return 0;
        }
    }

    @Deprecated
    public static int getRssiLevel(Context context) {
        try {
            WifiInfo info = ((WifiManager)context.getSystemService("wifi")).getConnectionInfo();
            return WifiManager.calculateSignalLevel((int)info.getRssi(), (int)5);
        }
        catch (Exception e) {
            LogUtil.e(e);
            return 1;
        }
    }

    public static void setMobileDataEnabled(Context context, boolean enabled) {
        try {
            ConnectivityManager conman = (ConnectivityManager)context.getSystemService("connectivity");
            Class<?> conmanClass = Class.forName(conman.getClass().getName());
            Field iConnectivityManagerField = conmanClass.getDeclaredField("mService");
            iConnectivityManagerField.setAccessible(true);
            Object iConnectivityManager = iConnectivityManagerField.get(conman);
            Class<?> iConnectivityManagerClass = Class.forName(iConnectivityManager.getClass().getName());
            Method setMobileDataEnabledMethod = iConnectivityManagerClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke(iConnectivityManager, enabled);
        }
        catch (Exception e) {
            LogUtil.e(e);
        }
    }

    public static String getIpAddress() {
        Application application = App.instance();
        if (application == null) {
            return "";
        }
        ConnectivityManager manager = (ConnectivityManager)application.getSystemService("connectivity");
        if (manager == null) {
            return "";
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        if (info == null) {
            return "";
        }
        if (info.isAvailable()) {
            if (info.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface intf = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                        while (enumIpAddr.hasMoreElements()) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (SocketException ex) {
                    LogUtil.e(ex);
                }
            } else {
                WifiManager wifiManager = (WifiManager)application.getApplicationContext().getSystemService("wifi");
                if (wifiManager == null) {
                    return "";
                }
                if (!wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(true);
                }
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                int ipAddress = wifiInfo.getIpAddress();
                return NetInfoUtil.intToIp(ipAddress);
            }
        }
        return "";
    }

    public static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }
}

