/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.statusbar;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.view.Window;
import com.gymchina.library.statusbar.StatusBarColorMiuiImpl$Companion$WhenMappings;
import com.gymchina.library.statusbar.StatusBarColorMode;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/statusbar/StatusBarColorMiuiImpl;", "", "()V", "Companion", "library_release"})
public final class StatusBarColorMiuiImpl {
    public static final Companion Companion = new Companion(null);

    private StatusBarColorMiuiImpl() {
        throw (Throwable)new Error("Do not need instantiate!");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0003J\b\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lcom/gymchina/library/statusbar/StatusBarColorMiuiImpl$Companion;", "", "()V", "canHandle", "", "changeMode", "", "window", "Landroid/view/Window;", "mode", "Lcom/gymchina/library/statusbar/StatusBarColorMode$Mode;", "isMIUI6Later", "isMiUIV6OrAbove", "library_release"})
    public static final class Companion {
        public final boolean canHandle() {
            return this.isMIUI6Later() | this.isMiUIV6OrAbove();
        }

        @SuppressLint(value={"PrivateApi"})
        public final void changeMode(@NotNull Window window, @NotNull StatusBarColorMode.Mode mode) {
            Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
            Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
            if (!this.canHandle()) {
                return;
            }
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                switch (StatusBarColorMiuiImpl$Companion$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                    case 1: {
                        extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                        break;
                    }
                    case 2: {
                        extraFlagField.invoke((Object)window, 0, darkModeFlag);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @SuppressLint(value={"PrivateApi"})
        private final boolean isMIUI6Later() {
            boolean bl;
            try {
                Class<?> clz = Class.forName("android.os.SystemProperties");
                Method mtd = clz.getMethod("get", String.class);
                Object object = mtd.invoke(null, "ro.miui.ui.version.name");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String val = (String)object;
                CharSequence charSequence = val;
                String string = "[vV]";
                String string2 = "";
                val = (string = new Regex(string)).replace(charSequence, string2);
                int version = Integer.parseInt(val);
                bl = version >= 6;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        private final boolean isMiUIV6OrAbove() {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
                String uiCode = properties.getProperty("ro.miui.ui.version.code", null);
                if (uiCode != null) {
                    int code = Integer.parseInt(uiCode);
                    return code >= 4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

