/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.phone;

import android.app.Activity;
import android.support.annotation.RequiresApi;
import android.view.DisplayCutout;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import notchtools.geek.com.notchtools.core.AbsNotchScreenSupport;
import notchtools.geek.com.notchtools.core.NotchProperty;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;
import notchtools.geek.com.notchtools.helper.NotchStatusBarUtils;
import notchtools.geek.com.notchtools.helper.ThreadUtils;

public class PVersionNotchScreen
extends AbsNotchScreenSupport {
    @Override
    @RequiresApi(api=28)
    public boolean isNotchScreen(Window window) {
        WindowInsets windowInsets = window.getDecorView().getRootWindowInsets();
        if (windowInsets == null) {
            return false;
        }
        DisplayCutout displayCutout = windowInsets.getDisplayCutout();
        return displayCutout != null && displayCutout.getBoundingRects() != null;
    }

    @Override
    @RequiresApi(api=28)
    public int getNotchHeight(Window window) {
        int notchHeight = 0;
        WindowInsets windowInsets = window.getDecorView().getRootWindowInsets();
        if (windowInsets == null) {
            return 0;
        }
        DisplayCutout displayCutout = windowInsets.getDisplayCutout();
        if (displayCutout == null || displayCutout.getBoundingRects() == null) {
            return 0;
        }
        notchHeight = displayCutout.getSafeInsetTop();
        return notchHeight;
    }

    @RequiresApi(api=28)
    public int getNotchHeightLandScape(Window window) {
        int notchHeight = 0;
        WindowInsets windowInsets = window.getDecorView().getRootWindowInsets();
        if (windowInsets == null) {
            return 0;
        }
        DisplayCutout displayCutout = windowInsets.getDisplayCutout();
        if (displayCutout == null || displayCutout.getBoundingRects() == null) {
            return 0;
        }
        notchHeight = displayCutout.getSafeInsetLeft();
        return notchHeight;
    }

    @Override
    @RequiresApi(api=28)
    public void fullScreenDontUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        NotchStatusBarUtils.setFullScreenWithSystemUi(activity.getWindow(), true);
        WindowManager.LayoutParams attributes = activity.getWindow().getAttributes();
        attributes.layoutInDisplayCutoutMode = 2;
        activity.getWindow().setAttributes(attributes);
        final Activity tmpAty = activity;
        final OnNotchCallBack tmpCallback = notchCallBack;
        ThreadUtils.post2UI(new Runnable(){

            @Override
            public void run() {
                PVersionNotchScreen.this.onBindCallBackWithNotchProperty(tmpAty, tmpCallback);
            }
        });
    }

    @Override
    @RequiresApi(api=28)
    public void fullScreenUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        NotchStatusBarUtils.setFullScreenWithSystemUi(activity.getWindow(), true);
        WindowManager.LayoutParams attributes = activity.getWindow().getAttributes();
        attributes.layoutInDisplayCutoutMode = 1;
        activity.getWindow().setAttributes(attributes);
        final Activity tmpAty = activity;
        final OnNotchCallBack tmpCallback = notchCallBack;
        ThreadUtils.post2UI(new Runnable(){

            @Override
            public void run() {
                PVersionNotchScreen.this.onBindCallBackWithNotchProperty(tmpAty, PVersionNotchScreen.this.getNotchHeight(tmpAty.getWindow()), tmpCallback);
            }
        });
    }

    @RequiresApi(api=28)
    public int getNotchHeight(Activity activity) {
        if (activity.getRequestedOrientation() == 0) {
            return this.getNotchHeightLandScape(activity.getWindow());
        }
        return this.getNotchHeight(activity.getWindow());
    }

    @Override
    @RequiresApi(api=28)
    protected void onBindCallBackWithNotchProperty(Activity activity, OnNotchCallBack notchCallBack) {
        if (notchCallBack != null) {
            NotchProperty notchProperty = new NotchProperty();
            notchProperty.setNotchHeight(this.getNotchHeight(activity));
            notchProperty.setNotch(this.isNotchScreen(activity.getWindow()));
            if (notchCallBack != null) {
                notchCallBack.onNotchPropertyCallback(notchProperty);
            }
        }
    }

    @Override
    @RequiresApi(api=28)
    protected void onBindCallBackWithNotchProperty(Activity activity, int marginTop, OnNotchCallBack notchCallBack) {
        if (notchCallBack != null) {
            NotchProperty notchProperty = new NotchProperty();
            notchProperty.setNotchHeight(this.getNotchHeight(activity));
            notchProperty.setNotch(this.isNotchScreen(activity.getWindow()));
            notchProperty.setMarginTop(marginTop);
            if (notchCallBack != null) {
                notchCallBack.onNotchPropertyCallback(notchProperty);
            }
        }
    }
}

