/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.phone;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.view.Window;
import java.lang.reflect.Method;
import notchtools.geek.com.notchtools.core.AbsNotchScreenSupport;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;
import notchtools.geek.com.notchtools.helper.NotchStatusBarUtils;
import notchtools.geek.com.notchtools.helper.SystemProperties;

public class MiuiNotchScreen
extends AbsNotchScreenSupport {
    private static final String TAG = MiuiNotchScreen.class.getSimpleName();

    @Override
    @RequiresApi(api=26)
    public boolean isNotchScreen(Window window) {
        return "1".equals(SystemProperties.getInstance().get("ro.miui.notch"));
    }

    @Override
    @RequiresApi(api=26)
    public int getNotchHeight(Window window) {
        if (!this.isNotchScreen(window)) {
            return 0;
        }
        int result = 0;
        if (window == null) {
            return 0;
        }
        Context context = window.getContext();
        result = this.isHideNotch(window.getContext()) ? NotchStatusBarUtils.getStatusBarHeight(context) : this.getRealNotchHeight(context);
        return result;
    }

    private int getRealNotchHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenDontUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenDontUseStatus(activity, notchCallBack);
        if (Build.VERSION.SDK_INT >= 26 && this.isNotchScreen(activity.getWindow())) {
            int FLAG_NOTCH = 1280;
            try {
                Method method = Window.class.getMethod("addExtraFlags", Integer.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)activity.getWindow(), FLAG_NOTCH);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fullScreenUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenUseStatus(activity, notchCallBack);
        if (Build.VERSION.SDK_INT >= 26 && this.isNotchScreen(activity.getWindow())) {
            int FLAG_NOTCH = 1792;
            try {
                Method method = Window.class.getMethod("addExtraFlags", Integer.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)activity.getWindow(), FLAG_NOTCH);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isHideNotch(Context activity) {
        return Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"force_black", (int)0) == 1;
    }
}

