/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.core;

import android.app.Activity;
import android.view.Window;
import notchtools.geek.com.notchtools.core.INotchSupport;
import notchtools.geek.com.notchtools.core.NotchProperty;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;
import notchtools.geek.com.notchtools.helper.NotchStatusBarUtils;

public abstract class AbsNotchScreenSupport
implements INotchSupport {
    @Override
    public int getStatusHeight(Window window) {
        return NotchStatusBarUtils.getStatusBarHeight(window.getContext());
    }

    @Override
    public void fullScreenDontUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        this.onBindCallBackWithNotchProperty(activity, notchCallBack);
        NotchStatusBarUtils.setFullScreenWithSystemUi(activity.getWindow(), true);
    }

    @Override
    public void fullScreenDontUseStatusForPortrait(Activity activity, OnNotchCallBack notchCallBack) {
        this.fullScreenDontUseStatus(activity, notchCallBack);
    }

    @Override
    public void fullScreenDontUseStatusForLandscape(Activity activity, OnNotchCallBack notchCallBack) {
        this.fullScreenDontUseStatus(activity, notchCallBack);
    }

    @Override
    public void fullScreenUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        this.onBindCallBackWithNotchProperty(activity, this.getNotchHeight(activity.getWindow()), notchCallBack);
        NotchStatusBarUtils.setFullScreenWithSystemUi(activity.getWindow(), true);
    }

    protected void onBindCallBackWithNotchProperty(Activity activity, OnNotchCallBack notchCallBack) {
        if (notchCallBack != null) {
            NotchProperty notchProperty = new NotchProperty();
            notchProperty.setNotchHeight(this.getNotchHeight(activity.getWindow()));
            notchProperty.setNotch(this.isNotchScreen(activity.getWindow()));
            if (notchCallBack != null) {
                notchCallBack.onNotchPropertyCallback(notchProperty);
            }
        }
    }

    protected void onBindCallBackWithNotchProperty(Activity activity, int marginTop, OnNotchCallBack notchCallBack) {
        if (notchCallBack != null) {
            NotchProperty notchProperty = new NotchProperty();
            notchProperty.setNotchHeight(this.getNotchHeight(activity.getWindow()));
            notchProperty.setNotch(this.isNotchScreen(activity.getWindow()));
            notchProperty.setMarginTop(marginTop);
            if (notchCallBack != null) {
                notchCallBack.onNotchPropertyCallback(notchProperty);
            }
        }
    }
}

