/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.phone;

import android.app.Activity;
import android.support.annotation.RequiresApi;
import android.view.Window;
import notchtools.geek.com.notchtools.core.AbsNotchScreenSupport;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;
import notchtools.geek.com.notchtools.helper.NotchStatusBarUtils;

public class OppoNotchScreen
extends AbsNotchScreenSupport {
    private static final String TAG = OppoNotchScreen.class.getSimpleName();

    @Override
    @RequiresApi(api=26)
    public boolean isNotchScreen(Window window) {
        if (window == null) {
            return false;
        }
        return window.getContext().getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    @Override
    @RequiresApi(api=26)
    public int getNotchHeight(Window window) {
        if (!this.isNotchScreen(window)) {
            return 0;
        }
        return NotchStatusBarUtils.getStatusBarHeight(window.getContext());
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenDontUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenDontUseStatus(activity, notchCallBack);
        if (this.isNotchScreen(activity.getWindow())) {
            NotchStatusBarUtils.setFakeNotchView(activity.getWindow());
        }
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenDontUseStatusForPortrait(Activity activity, OnNotchCallBack notchCallBack) {
        this.fullScreenDontUseStatus(activity, notchCallBack);
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenDontUseStatusForLandscape(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenDontUseStatusForLandscape(activity, notchCallBack);
        if (this.isNotchScreen(activity.getWindow())) {
            NotchStatusBarUtils.removeFakeNotchView(activity.getWindow());
        }
    }

    @Override
    public void fullScreenUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenUseStatus(activity, notchCallBack);
    }
}

