/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.annotation.SuppressLint;
import android.os.Build;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/RomUtil;", "", "()V", "Companion", "library_release"})
public final class RomUtil {
    public static final Companion Companion = new Companion(null);

    private RomUtil() {
        throw (Throwable)new Error("Do not need instantiate!");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000bH\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"Lcom/gymchina/library/common/utils/RomUtil$Companion;", "", "()V", "getEmuiVersion", "", "getMiuiVersion", "", "getSystemProperty", "", "propName", "is360Rom", "", "isFlyme4Later", "isHuaweiRom", "isMIUI6Later", "isMeizuRom", "isMiuiRom", "isOppoRom", "isVivoRom", "library_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * WARNING - bad return control flow
         */
        @Nullable
        public final String getSystemProperty(@NotNull String propName) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)propName, (String)"propName");
            BufferedReader input = null;
            try {
                Process process;
                Process process2 = process = Runtime.getRuntime().exec("getprop " + propName);
                Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
                input = new BufferedReader(new InputStreamReader(process2.getInputStream()), 1024);
                string = input.readLine();
            }
            catch (IOException iOException) {
                BufferedReader bufferedReader = input;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {
                    BufferedReader bufferedReader2 = input;
                    if (bufferedReader2 != null) {
                        bufferedReader2.close();
                    }
                    throw throwable;
                }
            }
            input.close();
            return string;
            return null;
        }

        public final double getEmuiVersion() {
            try {
                String version;
                String string = version = this.getSystemProperty("ro.build.version.emui");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                int n = StringsKt.indexOf$default((CharSequence)version, (String)"_", (int)0, (boolean)false, (int)6, null) + 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string4;
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                return 4.0;
            }
        }

        public final int getMiuiVersion() {
            try {
                String version;
                String string = version = this.getSystemProperty("ro.miui.ui.version.name");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                int n = 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string4;
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public final boolean isHuaweiRom() {
            String string = Build.MANUFACTURER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.MANUFACTURER");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"HUAWEI", (boolean)false, (int)2, null);
        }

        public final boolean isMiuiRom() {
            CharSequence charSequence;
            String string = this.getSystemProperty("ro.miui.ui.version.name");
            return string != null ? (charSequence = (CharSequence)string).length() > 0 : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isMeizuRom() {
            String prop;
            String string = prop = this.getSystemProperty("ro.build.display.id");
            if (string == null) return false;
            CharSequence charSequence = string;
            if (charSequence.length() <= 0) return false;
            boolean bl = true;
            if (!bl) return false;
            String string2 = prop;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"flyme", (boolean)false, (int)2, null)) return true;
            charSequence = prop;
            String string3 = ((String)charSequence).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"flyme", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean is360Rom() {
            String string = Build.MANUFACTURER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.MANUFACTURER");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"QiKU", (boolean)false, (int)2, null)) return true;
            String string2 = Build.MANUFACTURER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.MANUFACTURER");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"360", (boolean)false, (int)2, null)) return false;
            return true;
        }

        public final boolean isOppoRom() {
            CharSequence charSequence;
            String string = this.getSystemProperty("ro.build.version.opporom");
            return string != null ? (charSequence = (CharSequence)string).length() > 0 : false;
        }

        public final boolean isVivoRom() {
            CharSequence charSequence;
            String string = this.getSystemProperty("ro.vivo.os.version");
            return string != null ? (charSequence = (CharSequence)string).length() > 0 : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFlyme4Later() {
            String string = Build.FINGERPRINT;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.FINGERPRINT");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Flyme_OS_4", (boolean)false, (int)2, null)) return true;
            String string2 = Build.VERSION.INCREMENTAL;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.VERSION.INCREMENTAL");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Flyme_OS_4", (boolean)false, (int)2, null)) return true;
            if (!Pattern.compile("Flyme OS [4|5]", 2).matcher(Build.DISPLAY).find()) return false;
            return true;
        }

        @SuppressLint(value={"PrivateApi"})
        public final boolean isMIUI6Later() {
            boolean bl;
            try {
                Class<?> clz = Class.forName("android.os.SystemProperties");
                Method mtd = clz.getMethod("get", String.class);
                Object object = mtd.invoke(null, "ro.miui.ui.version.name");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String val = (String)object;
                CharSequence charSequence = val;
                String string = "[vV]";
                String string2 = "";
                val = (string = new Regex(string)).replace(charSequence, string2);
                int version = Integer.parseInt(val);
                bl = version >= 6;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

