/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/NetworkUtil;", "", "()V", "Companion", "library_release"})
public final class NetworkUtil {
    public static final Companion Companion = new Companion(null);

    private NetworkUtil() {
        throw (Throwable)new Error("Do not need instantiate!");
    }

    @JvmStatic
    public static final boolean isAvailable(@NotNull Context context) {
        return Companion.isAvailable(context);
    }

    @JvmStatic
    public static final boolean isWifiEnabled(@NotNull Context context) {
        return Companion.isWifiEnabled(context);
    }

    @JvmStatic
    public static final boolean isWifi(@NotNull Context context) {
        return Companion.isWifi(context);
    }

    @JvmStatic
    public static final boolean is3G(@NotNull Context context) {
        return Companion.is3G(context);
    }

    @JvmStatic
    public static final boolean is2G(@NotNull Context context) {
        return Companion.is2G(context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/gymchina/library/common/utils/NetworkUtil$Companion;", "", "()V", "is2G", "", "context", "Landroid/content/Context;", "is3G", "isAvailable", "isWifi", "isWifiEnabled", "library_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean isAvailable(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getApplicationContext().getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager manager = (ConnectivityManager)object;
            NetworkInfo info = manager.getActiveNetworkInfo();
            return info != null && info.isAvailable();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isWifiEnabled(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager mgrConn = (ConnectivityManager)object;
            Object object2 = context.getSystemService("phone");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager mgrTel = (TelephonyManager)object2;
            if (mgrConn.getActiveNetworkInfo() != null) {
                NetworkInfo networkInfo = mgrConn.getActiveNetworkInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo, (String)"mgrConn.activeNetworkInfo");
                if (networkInfo.getState() == NetworkInfo.State.CONNECTED) return true;
            }
            if (mgrTel.getNetworkType() != 3) return false;
            return true;
        }

        @JvmStatic
        public final boolean isWifi(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.getType() == 1;
        }

        @JvmStatic
        public final boolean is3G(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.getType() == 0;
        }

        @JvmStatic
        public final boolean is2G(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
            return activeNetInfo != null && (activeNetInfo.getSubtype() == 2 || activeNetInfo.getSubtype() == 1 || activeNetInfo.getSubtype() == 4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

