/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.gymchina.android.framework.base.AbsApplication;
import com.gymchina.android.framework.utils.LogUtil;
import com.gymchina.android.framework.utils.SpUtil;
import com.gymchina.android.framework.utils.StringUtil;
import java.util.UUID;

public final class DeviceUtil {
    public static final String DEVICE_ID_SP_NAME = "device_info";
    private static final String DEVICE_ID_SP_KEY = "device_id";

    private DeviceUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isPhone() {
        try {
            TelephonyManager manager = (TelephonyManager)AbsApplication.instance().getSystemService("phone");
            return manager != null && manager.getPhoneType() != 0;
        }
        catch (Exception e) {
            LogUtil.e(e);
            return false;
        }
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static String getDeviceId() {
        String deviceId = SpUtil.getStringPrefs((Context)AbsApplication.instance(), DEVICE_ID_SP_NAME, DEVICE_ID_SP_KEY, "");
        if (StringUtil.isNotNull(deviceId)) {
            return deviceId;
        }
        deviceId = DeviceUtil.getUniquePsuedoID();
        SpUtil.saveStringPrefs((Context)AbsApplication.instance(), DEVICE_ID_SP_NAME, DEVICE_ID_SP_KEY, deviceId, true);
        return deviceId;
    }

    @TargetApi(value=9)
    public static String getUniquePsuedoID() {
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        try {
            String serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception exception) {
            String serial = "serial";
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceId(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getDeviceId();
    }

    public static String getAndroidId(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }
}

