/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.framework.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.gymchina.android.framework.utils.CastUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CloneUtil {
    private CloneUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    @Nullable
    public static <T> T clone(T sourceObj) {
        try {
            if (sourceObj instanceof Parcelable) {
                return CastUtil.cast(CloneUtil.clone((Parcelable)sourceObj));
            }
            if (sourceObj instanceof Serializable) {
                return CastUtil.cast(CloneUtil.clone((Serializable)sourceObj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static <T extends Serializable> T clone(T sourceObj) {
        if (sourceObj == null) {
            return null;
        }
        Serializable cloneObj = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(sourceObj);
            oos.close();
            ByteArrayInputStream ins = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(ins);
            cloneObj = (Serializable)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)cloneObj;
    }

    @Nullable
    private static <T extends Parcelable> T clone(T sourceObj) {
        if (sourceObj == null) {
            return null;
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeParcelable(sourceObj, 0);
            parcel.setDataPosition(0);
            Parcelable parcelable = parcel.readParcelable(sourceObj.getClass().getClassLoader());
            return (T)parcelable;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
        return null;
    }
}

