/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.variable;

public class Arg {
    private static final String PREFIX = "$";
    private static final String ALL = "$@";
    private static final String FROM_PREFIX = "$@+";
    public static final String $0 = Arg.arg(0);
    public static final String $1 = Arg.arg(1);
    public static final String $2 = Arg.arg(2);
    public static final String $3 = Arg.arg(3);
    public static final String $4 = Arg.arg(4);
    public static final String $5 = Arg.arg(5);
    public static final String $6 = Arg.arg(6);
    public static final String $7 = Arg.arg(7);
    public static final String $8 = Arg.arg(8);
    public static final String $9 = Arg.arg(9);
    public static final String $all = "$@";

    public static final String arg(int i) {
        return PREFIX + i;
    }

    public static boolean isVariable(String expression) {
        return expression.startsWith(PREFIX);
    }

    public static int argIndex(String name) {
        if (name.startsWith(PREFIX)) {
            try {
                return Integer.parseInt(name.substring(PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static int argsFromIndex(String name) {
        if (name.startsWith(FROM_PREFIX)) {
            try {
                return Integer.parseInt(name.substring(FROM_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static final String args() {
        return "$@";
    }

    public static final String argsFrom(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("from cannot be negative: " + index);
        }
        return index == 0 ? "$@" : FROM_PREFIX + index;
    }

    private Arg() {
    }
}

