/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class ManifestResourceTransformer
implements ResourceTransformer {
    private final List<String> defaultAttributes = Arrays.asList("Export-Package", "Import-Package", "Provide-Capability", "Require-Capability");
    private String mainClass;
    private Map<String, Object> manifestEntries;
    private List<String> additionalAttributes;
    private boolean manifestDiscovered;
    private Manifest manifest;

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setManifestEntries(Map<String, Object> manifestEntries) {
        this.manifestEntries = manifestEntries;
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        if (!this.manifestDiscovered) {
            this.manifest = new Manifest(is);
            if (relocators != null && !relocators.isEmpty()) {
                String newValue;
                String attributeValue;
                Attributes attributes = this.manifest.getMainAttributes();
                for (String attribute : this.defaultAttributes) {
                    attributeValue = attributes.getValue(attribute);
                    if (attributeValue == null) continue;
                    newValue = this.relocate(attributeValue, relocators);
                    attributes.putValue(attribute, newValue);
                }
                if (this.additionalAttributes != null) {
                    for (String attribute : this.additionalAttributes) {
                        attributeValue = attributes.getValue(attribute);
                        if (attributeValue == null) continue;
                        newValue = this.relocate(attributeValue, relocators);
                        attributes.putValue(attribute, newValue);
                    }
                }
            }
            this.manifestDiscovered = true;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes attributes = this.manifest.getMainAttributes();
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Object> entry : this.manifestEntries.entrySet()) {
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.manifest.write(jos);
    }

    private String relocate(String originalValue, List<Relocator> relocators) {
        String newValue = originalValue;
        for (Relocator relocator : relocators) {
            String value;
            while (!(value = newValue).equals(newValue = relocator.relocateClass(value))) {
            }
        }
        return newValue;
    }
}

