/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static String getFileName(InputStream file) {
        String fileExt = FileUtils.getFileExt(file);
        String fileName = FileUtils.randomFileName(8, fileExt);
        return fileName;
    }

    public static String randomFileName(int len, String fileExt) {
        return System.currentTimeMillis() + "-yop-" + RandomStringUtils.randomAlphanumeric((int)len) + fileExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMimeType(File file) {
        String mimeType = "application/octet-stream";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            mimeType = FileUtils.getMimeType(stream);
        }
        catch (Exception e) {
            try {
                LOGGER.error("error when getMimeType, ex:", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(stream);
                throw throwable;
            }
            StreamUtils.closeQuietly(stream);
        }
        StreamUtils.closeQuietly(stream);
        return mimeType;
    }

    private static String getMimeType(InputStream stream) {
        String mimeType = "application/octet-stream";
        AutoDetectParser parser = new AutoDetectParser();
        parser.setParsers((Map)Maps.newHashMap());
        Metadata metadata = new Metadata();
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            parser.parse(stream, (ContentHandler)contenthandler, metadata);
            mimeType = metadata.get("Content-Type");
        }
        catch (Exception e) {
            LOGGER.error("error when getMimeType, ex:", (Throwable)e);
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileExt(File file) {
        String fileExt = ".bin";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileExt = FileUtils.getFileExt(stream);
        }
        catch (Exception e) {
            try {
                LOGGER.error("error when getFileExt, ex:", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(stream);
                throw throwable;
            }
            StreamUtils.closeQuietly(stream);
        }
        StreamUtils.closeQuietly(stream);
        return fileExt;
    }

    public static String getFileExt(InputStream stream) {
        String fileExt = ".bin";
        try {
            String mimeType = FileUtils.getMimeType(stream);
            fileExt = TikaConfig.getDefaultConfig().getMimeRepository().getRegisteredMimeType(mimeType).getExtension();
        }
        catch (MimeTypeException e) {
            LOGGER.error("error when getFileExt, ex:", (Throwable)e);
        }
        return fileExt;
    }

    public static InputStream getResourceAsStream(String resource) {
        File file;
        if (StringUtils.startsWith((CharSequence)resource, (CharSequence)"file://")) {
            resource = StringUtils.substring((String)resource, (int)"file://".length());
        }
        if ((file = new File(resource)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        while (StringUtils.startsWith((CharSequence)resource, (CharSequence)"/")) {
            resource = StringUtils.substring((String)resource, (int)1);
        }
        return FileUtils.getContextClassLoader().getResourceAsStream(resource);
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

