/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestAnalyzer {
    public static YopCredentials<?> getCredentials(YopRequestConfig requestConfig, AuthorizationReq authorizationReq) {
        YopCredentials credential = requestConfig.getCredentials();
        if (null == credential) {
            credential = YopCredentialsProviderRegistry.getProvider().getCredentials(requestConfig.getAppKey(), authorizationReq.getCredentialType());
        }
        if (null == credential) {
            throw new YopClientException("No credentials specified");
        }
        return credential;
    }

    public static boolean isEncryptSupported(YopCredentials<?> credential, YopRequestConfig requestConfig) {
        return !BooleanUtils.isFalse((Boolean)requestConfig.getNeedEncrypt()) && (!(credential instanceof YopPKICredentials) || !CertTypeEnum.RSA2048.equals((Object)((YopPKICredentials)credential).getCredential().getCertType())) && null != YopPlatformCredentialsProviderRegistry.getProvider().getLatestCredentials(credential.getAppKey(), CertTypeEnum.SM2.getValue());
    }

    public static YopEncryptor getEncryptor(YopRequestConfig requestConfig) {
        YopEncryptor encryptor;
        if (StringUtils.isBlank((CharSequence)requestConfig.getEncryptAlg())) {
            requestConfig.setEncryptAlg("SM4/CBC/PKCS5Padding");
        }
        if (null == (encryptor = YopEncryptorFactory.getEncryptor(requestConfig.getEncryptAlg()))) {
            throw new YopClientException("not supported the encryptAlg: " + requestConfig.getEncryptAlg());
        }
        return encryptor;
    }
}

