/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RequestEncryptor;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYopHttpClient
implements YopHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractYopHttpClient.class);
    protected static final Set<HttpMethodName> PAYLOAD_SUPPORT_METHODS = ImmutableSet.of((Object)((Object)HttpMethodName.POST), (Object)((Object)HttpMethodName.PUT), (Object)((Object)HttpMethodName.DELETE));
    protected final ClientConfiguration clientConfig;

    public AbstractYopHttpClient(ClientConfiguration clientConfig) {
        Preconditions.checkNotNull((Object)clientConfig, (Object)"config should not be null.");
        this.clientConfig = clientConfig;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Output extends BaseResponse, Input extends BaseRequest> Output execute(Request<Input> request, YopRequestConfig yopRequestConfig, ExecutionContext executionContext, HttpResponseHandler<Output> responseHandler) {
        Output analyzedResponse = null;
        YopHttpResponse httpResponse = null;
        try {
            this.preExecute(request, executionContext);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending Request: {}", request);
            }
            httpResponse = this.doExecute(request, yopRequestConfig);
            Output Output = analyzedResponse = (Output)responseHandler.handle(new HttpResponseHandleContext(httpResponse, request, executionContext));
            this.postExecute(analyzedResponse, httpResponse);
            return Output;
        }
        catch (YopClientException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new YopClientException("Unable to execute HTTP request, requestId:" + request.getRequestId() + ", apiUri:" + request.getResourcePath(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.postExecute(analyzedResponse, httpResponse);
                throw throwable;
            }
        }
    }

    protected abstract <Input extends BaseRequest> YopHttpResponse doExecute(Request<Input> var1, YopRequestConfig var2) throws IOException;

    protected <Output extends BaseResponse> void postExecute(Output analyzedResponse, YopHttpResponse httpResponse) {
        try {
            if (!(analyzedResponse instanceof YosDownloadResponse) && null != httpResponse) {
                httpResponse.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("error when postExecute, ex:", (Throwable)e);
        }
    }

    protected <Input extends BaseRequest> void preExecute(Request<Input> request, ExecutionContext executionContext) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        this.addStandardHeader(request, executionContext);
        this.encryptRequest(request, executionContext);
        this.signRequest(request, executionContext);
    }

    private <Input extends BaseRequest> void addStandardHeader(Request<Input> request, ExecutionContext executionContext) {
        request.addHeader("x-yop-appkey", executionContext.getYopCredentials().getAppKey());
        request.addHeader("User-Agent", this.clientConfig.getUserAgent());
    }

    private <Input extends BaseRequest> void encryptRequest(Request<Input> request, ExecutionContext executionContext) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        if (!executionContext.isEncryptSupported()) {
            LOGGER.debug("request not encrypted for no YopEncryptor found(or maybe a rsa request)");
            return;
        }
        RequestEncryptor.encrypt(request, executionContext.getEncryptor(), executionContext.getEncryptOptions().get());
    }

    private <Input extends BaseRequest> void signRequest(Request<Input> request, ExecutionContext executionContext) {
        executionContext.getSigner().sign(request, executionContext.getYopCredentials(), executionContext.getSignOptions());
    }

    protected <Input extends BaseRequest> boolean checkForMultiPart(Request<Input> request) throws YopClientException {
        boolean result;
        boolean bl = result = request.getMultiPartFiles() != null && request.getMultiPartFiles().size() > 0;
        if (result && !HttpMethodName.POST.equals((Object)request.getHttpMethod())) {
            throw new YopClientException("ContentType:multipart/form-data only support Post Request");
        }
        return result;
    }

    protected <Input extends BaseRequest> void buildHttpHeaders(Request<Input> request, HeaderBuilder headerBuilder) {
        headerBuilder.addHeader("Host", HttpUtils.generateHostHeader(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            headerBuilder.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public static interface HeaderBuilder {
        public void addHeader(String var1, String var2);
    }
}

