/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PrivateKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBaseCredentialsProvider
implements YopCredentialsProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getDefaultAppKey() {
        return "default";
    }

    protected YopCredentials<?> buildCredentials(YopAppConfig appConfig, String credentialType) {
        CertTypeEnum certType;
        if (null == appConfig || StringUtils.isEmpty((CharSequence)credentialType) || null == (certType = CertTypeEnum.parse((String)credentialType))) {
            throw new YopClientException("Illegal params when buildCredentials, credentialType:" + credentialType);
        }
        PrivateKey privateKey = appConfig.loadPrivateKey(certType);
        if (null == privateKey) {
            throw new YopClientException("No cert config found when buildCredentials, appKey:" + appConfig.getAppKey() + ", certType:" + certType);
        }
        PKICredentialsItem pkiCredentialsItem = new PKICredentialsItem(privateKey, certType);
        return new YopPKICredentials(appConfig.getAppKey(), pkiCredentialsItem);
    }

    protected String useDefaultIfBlank(String appKey) {
        return (String)StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)this.getDefaultAppKey());
    }
}

