/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;

@Singleton
public class StaticLoggerBinder {
    private final org.codehaus.plexus.logging.Logger logger;
    private static StaticLoggerBinder staticLoggerBinder;

    @Inject
    public StaticLoggerBinder(org.codehaus.plexus.logging.Logger logger) {
        this.logger = logger;
        staticLoggerBinder = this;
    }

    public static final StaticLoggerBinder getSingleton() {
        return staticLoggerBinder;
    }

    public String getLoggerFactoryClassStr() {
        return null;
    }

    public ILoggerFactory getLoggerFactory() {
        return s -> new Logger(){

            public String getName() {
                return StaticLoggerBinder.this.logger.getName();
            }

            public boolean isTraceEnabled() {
                return false;
            }

            public void trace(String s) {
            }

            public void trace(String s, Object o) {
            }

            public void trace(String s, Object o, Object o1) {
            }

            public void trace(String s, Object ... objects) {
            }

            public void trace(String s, Throwable throwable) {
            }

            public boolean isTraceEnabled(Marker marker) {
                return false;
            }

            public void trace(Marker marker, String s) {
            }

            public void trace(Marker marker, String s, Object o) {
            }

            public void trace(Marker marker, String s, Object o, Object o1) {
            }

            public void trace(Marker marker, String s, Object ... objects) {
            }

            public void trace(Marker marker, String s, Throwable throwable) {
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public void debug(String s) {
                StaticLoggerBinder.this.logger.debug(s);
            }

            public void debug(String s, Object o) {
                this.debug(s, new Object[]{o});
            }

            public void debug(String s, Object o, Object o1) {
                this.debug(s, new Object[]{o, o1});
            }

            public void debug(String s, Object ... objects) {
                StaticLoggerBinder.this.logger.debug(s + "-" + Arrays.deepToString(objects));
            }

            public void debug(String s, Throwable throwable) {
                StaticLoggerBinder.this.logger.debug(s, throwable);
            }

            public boolean isDebugEnabled(Marker marker) {
                return StaticLoggerBinder.this.logger.isDebugEnabled();
            }

            public void debug(Marker marker, String s) {
                StaticLoggerBinder.this.logger.debug(s);
            }

            public void debug(Marker marker, String s, Object o) {
                this.debug(s, o);
            }

            public void debug(Marker marker, String s, Object o, Object o1) {
                this.debug(s, new Object[]{o, o1});
            }

            public void debug(Marker marker, String s, Object ... objects) {
                this.debug(s, objects);
            }

            public void debug(Marker marker, String s, Throwable throwable) {
                this.debug(s, throwable);
            }

            public boolean isInfoEnabled() {
                return false;
            }

            public void info(String s) {
                StaticLoggerBinder.this.logger.info(s);
            }

            public void info(String s, Object o) {
                this.info(s, new Object[]{o});
            }

            public void info(String s, Object o, Object o1) {
                this.info(s, new Object[]{o, o1});
            }

            public void info(String s, Object ... objects) {
                StaticLoggerBinder.this.logger.info(s + "-" + Arrays.deepToString(objects));
            }

            public void info(String s, Throwable throwable) {
                StaticLoggerBinder.this.logger.info(s, throwable);
            }

            public boolean isInfoEnabled(Marker marker) {
                return StaticLoggerBinder.this.logger.isInfoEnabled();
            }

            public void info(Marker marker, String s) {
                StaticLoggerBinder.this.logger.info(s);
            }

            public void info(Marker marker, String s, Object o) {
                this.info(s, o);
            }

            public void info(Marker marker, String s, Object o, Object o1) {
                this.info(s, new Object[]{o, o1});
            }

            public void info(Marker marker, String s, Object ... objects) {
                this.info(s, objects);
            }

            public void info(Marker marker, String s, Throwable throwable) {
                this.info(s, throwable);
            }

            public boolean isWarnEnabled() {
                return false;
            }

            public void warn(String s) {
                StaticLoggerBinder.this.logger.warn(s);
            }

            public void warn(String s, Object o) {
                this.warn(s, new Object[]{o});
            }

            public void warn(String s, Object o, Object o1) {
                this.warn(s, new Object[]{o, o1});
            }

            public void warn(String s, Object ... objects) {
                StaticLoggerBinder.this.logger.warn(s + "-" + Arrays.deepToString(objects));
            }

            public void warn(String s, Throwable throwable) {
                StaticLoggerBinder.this.logger.warn(s, throwable);
            }

            public boolean isWarnEnabled(Marker marker) {
                return StaticLoggerBinder.this.logger.isWarnEnabled();
            }

            public void warn(Marker marker, String s) {
                StaticLoggerBinder.this.logger.warn(s);
            }

            public void warn(Marker marker, String s, Object o) {
                this.warn(s, o);
            }

            public void warn(Marker marker, String s, Object o, Object o1) {
                this.warn(s, new Object[]{o, o1});
            }

            public void warn(Marker marker, String s, Object ... objects) {
                this.warn(s, objects);
            }

            public void warn(Marker marker, String s, Throwable throwable) {
                this.warn(s, throwable);
            }

            public boolean isErrorEnabled() {
                return false;
            }

            public void error(String s) {
                StaticLoggerBinder.this.logger.error(s);
            }

            public void error(String s, Object o) {
                this.error(s, new Object[]{o});
            }

            public void error(String s, Object o, Object o1) {
                this.error(s, new Object[]{o, o1});
            }

            public void error(String s, Object ... objects) {
                StaticLoggerBinder.this.logger.error(s + "-" + Arrays.deepToString(objects));
            }

            public void error(String s, Throwable throwable) {
                StaticLoggerBinder.this.logger.error(s, throwable);
            }

            public boolean isErrorEnabled(Marker marker) {
                return StaticLoggerBinder.this.logger.isErrorEnabled();
            }

            public void error(Marker marker, String s) {
                StaticLoggerBinder.this.logger.error(s);
            }

            public void error(Marker marker, String s, Object o) {
                this.error(s, o);
            }

            public void error(Marker marker, String s, Object o, Object o1) {
                this.error(s, new Object[]{o, o1});
            }

            public void error(Marker marker, String s, Object ... objects) {
                this.error(s, objects);
            }

            public void error(Marker marker, String s, Throwable throwable) {
                this.error(s, throwable);
            }
        };
    }
}

